/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: fglorieux
 * Date: 24 sept. 2002
 * Time: 21:25:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.sitemap;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.BinaryDocument;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.constants.Node;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.util.Map;

public class DocumentReader extends AbstractReader implements Composable {

    // could implement Cacheable

    private ComponentManager manager;
    private DocumentBase base;
    private Document doc;
    private Response response;
    private Request request;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map map, String src, Parameters par)
            throws ProcessingException, SAXException, IOException {

        super.setup(resolver, map, src, par);
        // can't get a response and a acceptRequest by this way (copy/paste from other readers)
        try {
            this.response = ObjectModelHelper.getResponse(map);
            this.request = ObjectModelHelper.getRequest(map);
        } catch (Exception e) {
            // getLogger().error("can't get response or acceptRequest", e);
        }
        // parameters getted by a correct config of sitemap
        if (this.manager == null) {
            SDXException sdxE = new SDXException(null, SDXExceptionCode.ERROR_COMPONENT_MANAGER_NULL, null, null);
            throw new ProcessingException(sdxE.getMessage(), sdxE);
        }
        //our framework object
        FrameworkImpl frame = null;
        try {
            // TODO, support remote ?
            String appId = par.getParameter(Node.Name.APP, null);
            String baseId = par.getParameter(Node.Name.BASE, null);
            String id = par.getParameter(Node.Name.ID, null);
            String attid = par.getParameter(Node.Name.ATTID, null);
            if (Utilities.checkString(attid))
                id = Utilities.attId(id, attid);

            /*
            String type=par.getParameter("type", null);
            */

            // TODOException?: better handling of exceptions
            frame = (FrameworkImpl) this.manager.lookup(Framework.ROLE);
            if (frame != null) {
                Application app = frame.getApplicationById(appId);
                if (app != null) {
                    if (baseId != null && !"".equals(baseId))
                        this.base = app.getDocumentBase(baseId);
                    else
                        this.base = app.getDefaultDocumentBase();
                    this.doc = new BinaryDocument(id, null, null);
                }
            }
        } catch (Exception e) {
            // getLogger().error("can't get parameter", e);
        } finally {
            if (frame != null) manager.release(frame);
        }

    }

    /**
     * Get the mime-type of the output of this <code>Serializer</code>
     * This default implementation returns null to indicate that the
     * mime-type specified in the sitemap is to be used
     */
    public String getMimeType() {
        String out = null;
        if (base != null)
            try {
                out = base.getMimeType(doc);
            } catch (SDXException e) {
                // log ?
            }
        return out;
    }

    public void generate()
            throws IOException, ProcessingException {

        if (out == null) {
            // getLogger().debug("pas d'outputStream");
        }
        if (base == null) {
            // getLogger().debug("pas de base");
        }

        try {
            // need to set mime type of response (when we will get it)
/*
            final long expires = parameters.getParameterAsInteger("expires", -1);

            if (expires > 0) {
                response.setDateHeader("Expires", System.currentTimeMillis() + expires);
            }

            long contentLength = this.inputSource.getContentLength();
            if (contentLength != -1) {
                // FIXME (VG): Environment has setContentLength, and
                // Response interface has not. Strange.
                response.setHeader("Content-Length", Long.toString(contentLength));
            }
            response.setHeader("Accept-Ranges", "bytes");
*/
            if (this.base != null) {
                this.base.getDocument(this.doc, out);
                out.flush();
            }
        } catch (Exception e) {
            // getLogger().error("SDXException", e);
            ;
        }

    }

    /**
     * Recycle the component
     */
    /*public void recycle() {
       super.recycle();
       this.base = null;
       this.doc = null;
       this.manager = null;
       this.acceptRequest = null;
       this.response = null;
    }
    */


}
