/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.util.OAIUtilities;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.SAXException;

import java.io.File;
import java.net.MalformedURLException;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 24, 2003
 * Time: 12:05:45 PM
 * To change this template use Options | File Templates.
 */
public class OAIComponentImpl implements LogEnabled, OAIComponent,
        Contextualizable, Composable, Configurable, /*Parameterizable,*/ Initializable,
        ThreadSafe {

    /** The component manager. */
    private ComponentManager manager = null;
    /** The compenent's context. */
    private Context context = null;
    /** The servlet "context directory" : file:/{TOMCAT_HOME}/webapps/{sdx}/. */
    private String contextPath = null;
    /** The components's working directory : {sdx}. */
    private File workDir = null;
    protected Logger logger = null;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        if (context == null) throw new ContextException("Context provided was null", null);

        this.context = context;

        //getting a working directory
        if (this.workDir == null) {
            //getting the default one
            this.workDir = (File) context.get(Constants.CONTEXT_WORK_DIR);
        }

        //if none was provided, get a context path
        org.apache.cocoon.environment.Context ctx =
                (org.apache.cocoon.environment.Context) context.get(Constants.CONTEXT_ENVIRONMENT_CONTEXT);

        // Determine the context directory, preferably as a file
        // FIXME (SW) - this is purposely redundant with some code in CocoonServlet
        // to have the same rootPath. How to avoid this ?
        try {
            String rootPath = ctx.getRealPath("/");
            if (rootPath != null) {
                this.contextPath = new File(rootPath).toURL().toExternalForm();
            } else {
                String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                this.contextPath = webInf.substring(0, webInf.length() - "WEB-INF".length());
            }
        } catch (MalformedURLException e) {
            OAIUtilities.logWarn(logger, "Could not get context directory", e);
            this.contextPath = "";
        }

    }


    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public void initialize() throws Exception {
    }


    /**
     * Gets the framework's logger.
     *
     * @return  The logger.
     */
    public Logger getLogger() {
        return logger;
    }


    public void acceptRequest(OAIRepository repo, Request cocoonRequest, XMLConsumer consumer) throws SAXException {
        //building the request
        if (repo != null && cocoonRequest != null && consumer != null) {
            OAIRequest request = new OAIRequestImpl();
            request.enableLogging(this.logger);
            request.setRequest(cocoonRequest);

            //generating a response
            OAIResponse response = new OAIResponseImpl();
            response.enableLogging(this.logger);
            response.setRepository(repo);
            response.setRequest(request);
            //setting the consumer of the repository events
            repo.setConsumer(response);
            response.setConsumer(consumer);
            response.sendResponse();
        }
    }


    public void receiveResponse(String requestUrl, OAIHarvester harvester, String identifierNodeName) {
        if (harvester != null && OAIUtilities.checkString(requestUrl)) {
            harvester.setIdentifierName(identifierNodeName);
            harvester.receiveSynchronizedRequest(requestUrl);
        }

    }


}
