/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;

class LegacyDevices {
    private Vector useragents;
    private Vector profileRefs;
    private Workspace workspace;

    protected LegacyDevices(Workspace workspace, String string) throws ParserConfigurationException {
        this.workspace = workspace;
        this.useragents = new Vector();
        this.profileRefs = new Vector();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            this.traverse(documentBuilder.parse(string));
        }
        catch (Exception exception) {
            this.workspace.printDebug("LegacyDevices: Cannot load legacy device configuration file from " + string);
            this.workspace.printDebug(exception.toString());
        }
    }

    protected String getReference(String string) {
        int n = 0;
        while (n < this.useragents.size()) {
            if (string.lastIndexOf((String)this.useragents.get(n)) != -1) {
                this.workspace.printDebug("LegacyDevices: Useragent string " + string);
                this.workspace.printDebug(" maps on to " + (String)this.profileRefs.get(n));
                return (String)this.profileRefs.get(n);
            }
            ++n;
        }
        return null;
    }

    private void traverse(Node node) {
        Object object;
        if (node.getNodeName().equals("legacyDevice") && node.hasChildNodes()) {
            object = node.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                String string;
                Node node2 = object.item(n);
                if (node2.getNodeName().equals("useragentstring")) {
                    string = node2.getFirstChild().getNodeValue();
                    this.useragents.add(string);
                } else if (node2.getNodeName().equals("profileref")) {
                    string = node2.getFirstChild().getNodeValue();
                    this.profileRefs.add(string);
                }
                ++n;
            }
        } else if (node.hasChildNodes()) {
            this.traverse(node.getFirstChild());
        }
        object = node.getNextSibling();
        if (object != null) {
            this.traverse((Node)object);
        }
    }
}

