/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.Workspace;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CapabilityClass {
    private Vector classes = new Vector();
    private Workspace workspace;

    public CapabilityClass(Workspace workspace, String string) throws ParserConfigurationException {
        this.workspace = workspace;
        this.workspace.printDebug("CapabilityClass: Processing " + string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            this.traverse(documentBuilder.parse(string));
        }
        catch (Exception exception) {
            this.workspace.printDebug("Capability class: Cannot load " + string);
        }
    }

    public Vector evaluate(Profile profile) {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = ((AbstractList)this.classes).iterator();
        while (iterator.hasNext()) {
            String string;
            CapClass capClass = (CapClass)iterator.next();
            Iterator iterator2 = ((AbstractList)capClass.constraints).iterator();
            Stack<Boolean> stack = new Stack<Boolean>();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                string = iterator2.next();
                if (string instanceof Operand) {
                    object2 = (Operand)((Object)string);
                    object = ((Operand)object2).type;
                    int n = ((Operand)object2).children;
                    if (((String)object).equals("and")) {
                        while (n-- > 1) {
                            stack.push(new Boolean((Boolean)stack.pop() != false && (Boolean)stack.pop() != false));
                        }
                        continue;
                    }
                    if (((String)object).equals("or")) {
                        while (n-- > 1) {
                            stack.push(new Boolean((Boolean)stack.pop() != false || (Boolean)stack.pop() != false));
                        }
                        continue;
                    }
                    if (!((String)object).equals("not")) continue;
                    stack.push(new Boolean((Boolean)stack.pop() == false));
                    continue;
                }
                if (!(string instanceof Operator)) continue;
                object2 = (Operator)((Object)string);
                object = profile.getAttribute(((Operator)object2).attribute);
                Vector vector2 = ((ProfileAttribute)object).get();
                String string2 = ((ProfileAttribute)object).getType();
                String string3 = ((Operator)object2).type;
                String string4 = ((Operator)object2).value;
                if (object == null) continue;
                if (string2.equals("Number")) {
                    int n = Integer.parseInt((String)vector2.firstElement());
                    int n2 = Integer.parseInt(string4);
                    stack.push(new Boolean(string3.equals("greaterthan") && n > n2 || string3.equals("greaterthanequals") && n >= n2 || string3.equals("lessthan") && n < n2 || string3.equals("lessthanequals") && n <= n2 || string3.equals("equals") && n == n2));
                    continue;
                }
                if (string2.equals("Dimension")) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)vector2.firstElement(), "x");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "x");
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer2.nextToken());
                    stack.push(new Boolean(string3.equals("greaterthan") && n > n4 && n3 > n5 || string3.equals("greaterthanequals") && n >= n4 && n3 >= n5 || string3.equals("lessthan") && n < n4 && n3 < n5 || string3.equals("lessthanequals") && n <= n4 && n3 <= n5 || string3.equals("equals") && n == n4 && n3 == n5));
                    continue;
                }
                if (string2.equals("Literal")) {
                    stack.push(new Boolean(string3.equals("equals") && ((ProfileAttribute)object).getCollectionType().equals("Simple") && ((String)vector2.firstElement()).equals(string4) || string3.equals("contains") && vector2.contains(string4)));
                    continue;
                }
                if (string2.equals("Boolean") && string3.equals("true")) {
                    stack.push(new Boolean(((String)vector2.firstElement()).equals("Yes")));
                    continue;
                }
                this.workspace.printDebug("CapabilityClass: Operator applied to illegal attribute type");
                this.workspace.printDebug(string2 + " " + string3);
            }
            string = capClass.name;
            if (!stack.empty()) {
                if (!((Boolean)stack.pop()).booleanValue()) continue;
                vector.add(string);
                continue;
            }
            this.workspace.printDebug("CapabilityClass: Stack error for " + string);
        }
        return vector;
    }

    private void traverse(Node node) {
        Object object;
        String string = node.getNodeName();
        if (string.equals("class")) {
            object = new CapClass();
            ((CapClass)object).name = CapabilityClass.getAttribute(node, "name");
            ((CapClass)object).constraints = new TraverseCapabilityClass(node);
            this.classes.add(object);
        } else if (node.hasChildNodes()) {
            this.traverse(node.getFirstChild());
        }
        object = node.getNextSibling();
        if (object != null) {
            this.traverse((Node)object);
        }
    }

    private static String getAttribute(Node node, String string) {
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            String string3 = attr.getName();
            if (string3.equals(string)) {
                string2 = attr.getValue();
            }
            ++n;
        }
        return string2;
    }

    protected class CapClass {
        String name;
        Vector constraints;

        protected CapClass() {
        }

        public String toString() {
            return "[ " + this.name + " " + this.constraints;
        }
    }

    protected class Operand {
        String type;
        int children;

        protected Operand(String string, int n) {
            this.type = string;
            this.children = n;
        }

        public String toString() {
            return "[ " + this.type + " " + this.children + " ]\n";
        }
    }

    protected class Operator {
        String type;
        String attribute;
        String value;

        protected Operator(String string, String string2, String string3) {
            this.type = string;
            this.attribute = string2;
            this.value = string3;
        }

        public String toString() {
            return "[ " + this.type + " , " + this.attribute + " , " + this.value + " ]\n";
        }
    }

    protected class TraverseCapabilityClass
    extends Stack {
        protected TraverseCapabilityClass(Node node) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                this.traverseOperator(nodeList.item(n));
                ++n;
            }
        }

        private int childCount(Node node) {
            int n = 0;
            NodeList nodeList = node.getChildNodes();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                if (this.traverseOperator(nodeList.item(n2))) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        private boolean traverseOperator(Node node) {
            String string = node.getNodeName();
            if (string.equals("and") || string.equals("or")) {
                this.add(new Operand(string, this.childCount(node)));
            } else if (string.equals("not")) {
                if (this.childCount(node) == 1) {
                    this.add(new Operand(string, 1));
                } else {
                    CapabilityClass.this.workspace.printDebug("CapabilityClass: NOT can only take a single operator");
                }
            } else if (string.equals("lessthan") || string.equals("greaterthan") || string.equals("lessthanequals") || string.equals("greaterthanequals") || string.equals("equals") || string.equals("contains")) {
                this.add(new Operator(string, node.getFirstChild().getNodeValue(), CapabilityClass.getAttribute(node, "value")));
            } else if (string.equals("true")) {
                this.add(new Operator(string, node.getFirstChild().getNodeValue(), null));
            } else {
                return false;
            }
            return true;
        }
    }
}

