/*
 * Decompiled with CFR 0.152.
 */
package thinlet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import thinlet.Thinlet;

public class FrameLauncher
extends Frame
implements WindowListener {
    protected transient Thinlet content;
    private transient Image doublebuffer;
    private int width;
    private int height;

    public FrameLauncher(String title, Thinlet content, int width, int height) {
        super(title);
        this.content = content;
        this.width = width;
        this.height = height;
        this.add((Component)content, "Center");
        this.addWindowListener(this);
    }

    public void start() {
        this.pack();
        Insets is = this.getInsets();
        this.width += is.left + is.right;
        this.height += is.top + is.bottom;
        Dimension ss = this.getToolkit().getScreenSize();
        this.width = Math.min(this.width, ss.width);
        this.height = Math.min(this.height, ss.height);
        this.setBounds((ss.width - this.width) / 2, (ss.height - this.height) / 2, this.width, this.height);
        ((Graphics2D)this.getGraphics()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setVisible(true);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.doublebuffer == null) {
            Dimension d = this.getSize();
            this.doublebuffer = this.createImage(d.width, d.height);
        }
        Graphics dg = this.doublebuffer.getGraphics();
        dg.setClip(g.getClipBounds());
        super.paint(dg);
        dg.dispose();
        g.drawImage(this.doublebuffer, 0, 0, this);
    }

    public void doLayout() {
        if (this.doublebuffer != null) {
            this.doublebuffer.flush();
            this.doublebuffer = null;
        }
        super.doLayout();
    }

    public void windowClosing(WindowEvent e) {
        if (this.content.destroy()) {
            System.exit(0);
        }
        this.setVisible(true);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

