/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.NsIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Store;
import com.hp.hpl.mesa.rdf.jena.common.StoreCom;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;

public class StoreRDB
extends StoreCom
implements Store {
    protected IRDBDriver m_dbDriver;
    protected ModelRDB m_model;

    protected StoreRDB(IRDBDriver iRDBDriver) {
        this.m_dbDriver = iRDBDriver;
        this.m_dbDriver.attachStore(this);
    }

    public static StoreRDB createDB(IRDBDriver iRDBDriver) throws RDFRDBException {
        if (!iRDBDriver.isDBFormatOK()) {
            iRDBDriver.formatDB();
        }
        return new StoreRDB(iRDBDriver);
    }

    public static StoreRDB openDB(IRDBDriver iRDBDriver) throws RDFRDBException {
        if (!iRDBDriver.isDBFormatOK()) {
            throw new RDFRDBException("Database is not formating for RDF storage, try createDB");
        }
        return new StoreRDB(iRDBDriver);
    }

    public void attachModel(ModelRDB modelRDB) {
        this.m_model = modelRDB;
    }

    public IRDBDriver getDriver() {
        return this.m_dbDriver;
    }

    public void close() {
        if (this.m_dbDriver != null) {
            this.m_dbDriver.detachStore(this);
            this.m_dbDriver = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void begin() throws RDFException {
        try {
            this.m_dbDriver.getSQLCache().flushPreparedStatementCache();
            Connection connection = this.m_dbDriver.getConnection();
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Transaction support failed: ", (Exception)sQLException);
        }
    }

    public void abort() throws RDFException {
        try {
            Connection connection = this.m_dbDriver.getConnection();
            connection.rollback();
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Transaction support failed: ", (Exception)sQLException);
        }
    }

    public void commit() throws RDFException {
        try {
            Connection connection = this.m_dbDriver.getConnection();
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Transaction support failed: ", (Exception)sQLException);
        }
    }

    public Resource createResource(Model model) throws RDFException {
        return new ResourceImplRDB(model);
    }

    public Resource createResource(String string, Model model) throws RDFException {
        return new ResourceImplRDB(string, model);
    }

    public Property createProperty(String string, Model model) throws RDFException {
        return new PropertyImplRDB(string, model);
    }

    public Property createProperty(String string, String string2, Model model) throws RDFException {
        return new PropertyImplRDB(string, string2, model);
    }

    public Resource getResource(String string, Model model) throws RDFException {
        return this.m_dbDriver.getResource(string, (ModelRDB)model);
    }

    public Property getProperty(Property property) throws RDFException {
        return this.m_dbDriver.getProperty(property.getURI(), this.m_model);
    }

    public synchronized void add(Statement statement) throws RDFException {
        this.m_dbDriver.addStatement(this.convertStatement(statement), this.m_model);
    }

    public synchronized void remove(Statement statement) throws RDFException {
        Resource resource = this.m_model.convert(statement.getSubject());
        Property property = this.m_model.convert(statement.getPredicate());
        RDFNode rDFNode = this.m_model.convert(statement.getObject());
        this.m_dbDriver.deleteStatement(resource, property, rDFNode, this.m_model);
    }

    protected Statement convertStatement(Statement statement) throws RDFException {
        Resource resource = statement.getSubject();
        Resource resource2 = this.m_model.convert(resource);
        Property property = statement.getPredicate();
        Property property2 = this.m_model.convert(property);
        RDFNode rDFNode = statement.getObject();
        RDFNode rDFNode2 = this.m_model.convert(rDFNode);
        if (resource != resource2 || property != property2 || rDFNode != rDFNode2) {
            return this.createStatement(resource2, property2, rDFNode2, this.m_model);
        }
        return statement;
    }

    public synchronized int size() throws RDFException {
        Iterator iterator = this.list();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public synchronized boolean contains(Statement statement) throws RDFException {
        Resource resource = this.m_model.convert(statement.getSubject());
        Property property = this.m_model.convert(statement.getPredicate());
        RDFNode rDFNode = this.m_model.convert(statement.getObject());
        return this.m_dbDriver.isStatementPresent(resource, property, rDFNode, this.m_model);
    }

    public synchronized boolean contains(Resource resource, Property property) throws RDFException {
        return this.notEmpty(this.m_dbDriver.listStatements(this.m_model.convert(resource), this.m_model.convert(property), null, this.m_model));
    }

    private boolean notEmpty(ResultSetIterator resultSetIterator) {
        boolean bl = false;
        if (resultSetIterator.hasNext()) {
            bl = true;
            resultSetIterator.close();
        }
        return bl;
    }

    public synchronized Iterator list() throws RDFException {
        return this.m_dbDriver.listStatements(null, null, null, this.m_model);
    }

    public synchronized Iterator list(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return this.m_dbDriver.listStatements(this.m_model.convert(resource), this.m_model.convert(property), this.m_model.convert(rDFNode), this.m_model);
    }

    public ResultSetIterator listStatements(IConstraints iConstraints, ModelRDB modelRDB) throws RDFException {
        return iConstraints.runQuery(this.m_dbDriver, modelRDB);
    }

    public IConstraints createConstraints(ModelRDB modelRDB) {
        return this.m_dbDriver.createConstraints(modelRDB);
    }

    public synchronized Iterator listBySubject(Resource resource) throws RDFException {
        return this.m_dbDriver.listStatements(this.m_model.convert(resource), null, null, this.m_model);
    }

    public synchronized Iterator listByPredicate(Property property) throws RDFException {
        return this.m_dbDriver.listStatements(null, this.m_model.convert(property), null, this.m_model);
    }

    public synchronized Iterator listByObject(RDFNode rDFNode) throws RDFException {
        return this.m_dbDriver.listStatements(null, null, this.m_model.convert(rDFNode), this.m_model);
    }

    public synchronized ResIterator listSubjects() throws RDFException {
        return new ResIteratorImpl(this.m_dbDriver.listSubjects(this.m_model), null);
    }

    public synchronized NsIterator listNameSpaces() throws RDFException {
        return new NsIteratorImpl(this.m_dbDriver.listNamespaces(this.m_model), null);
    }
}

