/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.hp.hpl.jena.rdf.query.Constraint;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.rdf.query.TriplePattern;
import com.hp.hpl.jena.rdf.query.util.ModelLoader;
import com.hp.hpl.jena.util.Log;
import java.util.Iterator;
import java.util.Set;

public class QueryEngine {
    Query query;
    Set results;
    static final int bufferCapacity = 5;
    Object endOfPipeMarker = new Object();
    volatile boolean queryStop = false;
    boolean queryInitialised = false;
    static int queryCount = 0;
    int idQueryExecution;
    long triplePatterns = 0L;
    long queryStartTime = -1L;

    public QueryEngine(Query query) {
        this.query = query;
        this.queryStop = false;
        this.idQueryExecution = ++queryCount;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.query.getSource() == null) {
            if (this.query.sourceURL == null) {
                Log.warning("No data for query (no URL, no model)", "QueryEngine", "init");
                throw new QueryException("No model for query");
            }
            long l = System.currentTimeMillis();
            this.query.setSource(ModelLoader.loadModel(this.query.sourceURL, null));
            this.query.loadTime = System.currentTimeMillis() - l;
        }
    }

    public QueryResults exec() {
        this.init();
        ResultBinding resultBinding = new ResultBinding();
        final BoundedBuffer boundedBuffer = new BoundedBuffer(5);
        final BoundedBuffer boundedBuffer2 = this.query.constraints.isEmpty() ? boundedBuffer : new BoundedBuffer(5);
        this.queryStartTime = System.currentTimeMillis();
        new Thread("Triples-" + this.idQueryExecution){

            public void run() {
                QueryEngine.this.execTriples(boundedBuffer);
            }
        }.start();
        if (boundedBuffer2 != boundedBuffer) {
            new Thread("Constraints-" + this.idQueryExecution){

                public void run() {
                    QueryEngine.this.execConstraints(boundedBuffer, boundedBuffer2);
                }
            }.start();
        } else if (this.query.loggingOn) {
            Log.debug("No constraint pipe stage", "Query", "exec");
        }
        ResultsIterator resultsIterator = new ResultsIterator(boundedBuffer2);
        return new QueryResults(this.query.resultVars, this, resultsIterator);
    }

    void stop() {
        if (!this.queryStop) {
            this.queryStop = true;
        }
    }

    private void execConstraints(BoundedBuffer boundedBuffer, BoundedBuffer boundedBuffer2) {
        int n = 0;
        int n2 = 0;
        try {
            Object object;
            while (!this.queryStop && (object = boundedBuffer.take()) != this.endOfPipeMarker) {
                ++n;
                ResultBinding resultBinding = (ResultBinding)object;
                boolean bl = true;
                Iterator iterator = this.query.constraints.iterator();
                while (iterator.hasNext()) {
                    Constraint constraint = (Constraint)iterator.next();
                    if (constraint.isSatified(this.query, resultBinding)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                ++n2;
                boundedBuffer2.put((Object)resultBinding);
            }
            boundedBuffer2.put(this.endOfPipeMarker);
            return;
        }
        catch (InterruptedException interruptedException) {
            Sys.unhandledException(interruptedException, "QueryEngine", "execConstraints");
            return;
        }
    }

    private void execTriples(BoundedBuffer boundedBuffer) {
        try {
            this.execTriplesWorker(boundedBuffer, new ResultBinding(), 0);
            boundedBuffer.put(this.endOfPipeMarker);
        }
        catch (InterruptedException interruptedException) {
            Sys.unhandledException(interruptedException, "QueryEngine", "execTriples");
        }
    }

    private void execTriplesWorker(BoundedBuffer boundedBuffer, ResultBinding resultBinding, int n) {
        if (this.query.loggingOn) {
            Log.finer("Triple matching: " + (n + 1) + " of " + this.query.triplePatterns.size(), "QueryEngine", "execTriplesWorker");
            Log.finer("Triple matching: " + (resultBinding == null ? "<<null ResultBinding>>" : resultBinding.toString()), "QueryEngine", "execTriplesWorker");
        }
        if (this.queryStop) {
            return;
        }
        if (n > this.query.triplePatterns.size() - 1) {
            try {
                boundedBuffer.put((Object)resultBinding);
            }
            catch (InterruptedException interruptedException) {
                Sys.unhandledException(interruptedException, "QueryEngine", "execTriplesWorker");
            }
            return;
        }
        ++this.triplePatterns;
        int n2 = 0;
        TriplePattern triplePattern = (TriplePattern)this.query.triplePatterns.get(n);
        Iterator iterator = triplePattern.match(this.query.loggingOn ? this.query.log : null, this, this.query.source, resultBinding);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ResultBinding resultBinding2 = (ResultBinding)iterator.next();
                if (this.query.loggingOn && this.query.log != null) {
                    Log.debug("Env: " + resultBinding2);
                }
                if (resultBinding2 == null) continue;
                ++n2;
                this.execTriplesWorker(boundedBuffer, resultBinding2, n + 1);
            }
        }
    }

    class ResultsIterator
    implements Iterator {
        BoundedBuffer pipe;
        Object nextThing;

        ResultsIterator(BoundedBuffer boundedBuffer) {
            this.pipe = boundedBuffer;
            this.nextThing = null;
        }

        public boolean hasNext() {
            try {
                boolean bl;
                if (QueryEngine.this.queryStop) {
                    return false;
                }
                if (this.nextThing == null) {
                    this.nextThing = this.pipe.take();
                }
                boolean bl2 = bl = this.nextThing != QueryEngine.this.endOfPipeMarker;
                if (QueryEngine.this.query.executeTime == -1L) {
                    QueryEngine.this.query.executeTime = System.currentTimeMillis() - QueryEngine.this.queryStartTime;
                }
                return bl;
            }
            catch (InterruptedException interruptedException) {
                Sys.unhandledException(interruptedException, "ResultsIterator", "hasNext");
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            Object object = this.nextThing;
            this.nextThing = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("ResultsIterator.remove");
        }
    }
}

