/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import java.util.Iterator;

public class PropertyAccessorImpl
implements PropertyAccessor {
    protected Property m_property = null;
    protected DAMLCommon m_val = null;

    public PropertyAccessorImpl(Property property, DAMLCommon dAMLCommon) {
        this.m_property = property;
        this.m_val = dAMLCommon;
    }

    public Property getProperty() {
        return this.m_property;
    }

    public int count() {
        return this.m_val.getNumPropertyValues(this.getProperty());
    }

    public Iterator getAll(boolean bl) {
        return this.m_val.getAll(this.getProperty(), bl);
    }

    public DAMLCommon get() {
        Iterator iterator = this.getAll(false);
        return iterator == null || !iterator.hasNext() ? null : (DAMLCommon)iterator.next();
    }

    public void add(DAMLCommon dAMLCommon) {
        try {
            this.m_val.addProperty(this.getProperty(), dAMLCommon);
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception: " + rDFException, rDFException);
        }
    }

    public void remove(DAMLCommon dAMLCommon) {
        this.m_val.removeProperty(this.getProperty(), dAMLCommon);
    }

    public boolean hasValue(DAMLCommon dAMLCommon) {
        Iterator iterator = this.getAll(false);
        while (iterator.hasNext()) {
            if (!dAMLCommon.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

