/*
 * Decompiled with CFR 0.152.
 */
package uk.co.weft.maybeupload;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import uk.co.weft.maybeupload.MultipartHandler;
import uk.co.weft.maybeupload.UploadException;

public class MaybeUploadRequestWrapper
extends Hashtable
implements ServletRequest,
HttpServletRequest {
    public final String MFDHEADER = "multipart/form-data";
    public int maxUpload;
    private HttpServletRequest request;
    private boolean saveUploadedFilesToDisk;
    private boolean isMultipart = false;
    private MultipartHandler decoder;
    private File workDir;

    public MaybeUploadRequestWrapper() throws IllegalArgumentException, IOException, UploadException {
        throw new UploadException("do not use the no-args variant of the " + this.getClass().getName() + " constructor");
    }

    public MaybeUploadRequestWrapper(HttpServletRequest httpServletRequest) throws IllegalArgumentException, IOException, UploadException {
        this(httpServletRequest, true, null, false, false, 524288);
    }

    public MaybeUploadRequestWrapper(HttpServletRequest httpServletRequest, File file, boolean bl, boolean bl2) throws IllegalArgumentException, IOException, UploadException {
        this(httpServletRequest, true, file, bl, bl2, 524288);
    }

    public MaybeUploadRequestWrapper(HttpServletRequest httpServletRequest, boolean bl, File file, boolean bl2, boolean bl3, int n) throws IllegalArgumentException, IOException, UploadException {
        String string = httpServletRequest.getContentType();
        this.request = httpServletRequest;
        this.maxUpload = n;
        if (string != null && string.toLowerCase().indexOf("multipart/form-data") > -1) {
            int n2 = httpServletRequest.getContentLength();
            this.isMultipart = true;
            this.workDir = file;
            this.saveUploadedFilesToDisk = bl;
            if (!(!bl || file.isDirectory() && file.canWrite())) {
                throw new IllegalArgumentException("Bad work directory: " + file);
            }
            if (n2 > this.maxUpload) {
                throw new IOException("Total upload data size too large");
            }
            this.decoder = new MultipartHandler(this, (InputStream)httpServletRequest.getInputStream(), n2, string, file, bl, bl2, bl3);
        }
    }

    public Object get(String string) {
        Vector<String> vector = null;
        if (this.isMultipart) {
            vector = (Vector<String>)super.get(string);
        } else {
            String[] stringArray = this.request.getParameterValues(string);
            Vector<String> vector2 = new Vector<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    vector2.addElement(stringArray[n]);
                    ++n;
                }
                vector = vector2.size() == 1 ? vector2.elementAt(0) : vector2;
            }
        }
        return vector;
    }

    public Object getAttribute(String string) {
        return this.request.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String string) {
        return this.request.getDateHeader(string);
    }

    public String getHeader(String string) {
        return this.request.getHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getHeaders(String string) {
        return this.request.getHeaders(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public int getIntHeader(String string) {
        return this.request.getIntHeader(string);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String string) {
        Object object = this.get(string);
        String string2 = null;
        if (object != null) {
            if (object instanceof Vector) {
                object = ((Vector)object).elementAt(0);
            }
            string2 = object.toString();
        }
        return string2;
    }

    public Enumeration getParameterNames() {
        if (this.isMultipart) {
            return this.decoder.values.keys();
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String string) {
        if (this.isMultipart) {
            Object object = this.get(string);
            String[] stringArray = null;
            if (object != null) {
                if (object instanceof Vector) {
                    int n = ((Vector)object).size();
                    stringArray = new String[n];
                    int n2 = 0;
                    while (n2 < n) {
                        stringArray[n2] = ((Vector)object).elementAt(n2).toString();
                        ++n2;
                    }
                } else {
                    stringArray = new String[]{object.toString()};
                }
            }
            return stringArray;
        }
        return this.request.getParameterValues(string);
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRealPath(String string) {
        return this.request.getRealPath(string);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this.request.getRequestDispatcher(string);
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean bl) {
        return this.request.getSession(bl);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String string) {
        return this.request.isUserInRole(string);
    }

    public void removeAttribute(String string) {
        this.request.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.request.setAttribute(string, object);
    }
}

