/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.WMFConstants;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class WMFRecordStore
implements WMFConstants {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    private short readShort(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[2];
        dataInputStream.read(byArray);
        int n = (0xFF & byArray[1]) << 8;
        short s = (short)(0xFFFF & n);
        s = (short)(s | 0xFF & byArray[0]);
        return s;
    }

    private int readInt(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray);
        int n = (0xFF & byArray[3]) << 24;
        n |= (0xFF & byArray[2]) << 16;
        n |= (0xFF & byArray[1]) << 8;
        return n |= 0xFF & byArray[0];
    }

    public boolean read(DataInputStream dataInputStream) throws IOException {
        this.reset();
        this.setReading(true);
        int n = this.readInt(dataInputStream);
        if (n != -1698247209) {
            System.out.println("Unable to read file, it is not a Aldus Placable Metafile");
            this.setReading(false);
            return false;
        }
        int n2 = n;
        short s = this.readShort(dataInputStream);
        short s2 = this.readShort(dataInputStream);
        int n3 = this.readShort(dataInputStream);
        short s3 = this.readShort(dataInputStream);
        int n4 = this.readShort(dataInputStream);
        short s4 = this.readShort(dataInputStream);
        int n5 = this.readInt(dataInputStream);
        int n6 = this.readShort(dataInputStream);
        n2 = this.readShort(dataInputStream);
        s = this.readShort(dataInputStream);
        s2 = this.readShort(dataInputStream);
        n3 = this.readInt(dataInputStream);
        s3 = this.readShort(dataInputStream);
        n4 = this.readInt(dataInputStream);
        s4 = this.readShort(dataInputStream);
        n5 = 1;
        n6 = 0;
        this.numRecords = 0;
        this.numObjects = s3;
        this.objectVector.ensureCapacity(this.numObjects);
        for (int i = 0; i < this.numObjects; ++i) {
            this.objectVector.addElement(new GdiObject(i, false));
        }
        while (n5 > 0) {
            n6 = this.readInt(dataInputStream);
            n6 -= 3;
            n5 = this.readShort(dataInputStream);
            if (n5 <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n5) {
                case 1583: {
                    for (int i = 0; i < n6; ++i) {
                        short s5 = this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n7;
                    short s6 = this.readShort(dataInputStream);
                    short s7 = this.readShort(dataInputStream);
                    int n8 = this.readInt(dataInputStream);
                    int n9 = 2 * (n6 - 4);
                    byte[] byArray = new byte[n8];
                    for (n7 = 0; n7 < n8; ++n7) {
                        byArray[n7] = dataInputStream.readByte();
                    }
                    while (n7 < n9) {
                        dataInputStream.readByte();
                        ++n7;
                    }
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    metaRecord.AddElement(new Integer(s7));
                    metaRecord.AddElement(new Integer(s6));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1313: {
                    int n8;
                    short s8 = this.readShort(dataInputStream);
                    byte[] byArray = new byte[s8];
                    for (n8 = 0; n8 < s8; ++n8) {
                        byArray[n8] = dataInputStream.readByte();
                    }
                    n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n8));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 763: {
                    short s9 = this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    short s11 = this.readShort(dataInputStream);
                    int n7 = dataInputStream.readByte();
                    byte by = dataInputStream.readByte();
                    int n10 = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    byte by3 = dataInputStream.readByte();
                    byte by4 = dataInputStream.readByte();
                    byte by5 = dataInputStream.readByte();
                    byte by6 = dataInputStream.readByte();
                    int n11 = 2 * (n6 - 9);
                    byte[] byArray = new byte[n11];
                    for (int i = 0; i < n11; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    metaRecord.AddElement(new Integer(s9));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(s11));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 523: 
                case 524: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    short s12 = this.readShort(dataInputStream);
                    short s13 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s13));
                    metaRecord.AddElement(new Integer(s12));
                    this.records.addElement(metaRecord);
                    if (n5 != 524) break;
                    this.vpW = s12;
                    this.vpH = s13;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    int n12 = this.readInt(dataInputStream);
                    int n13 = n12 & 0xFF;
                    int n8 = (n12 & 0xFF00) >> 8;
                    int n9 = (n12 & 0xFF0000) >> 16;
                    int n14 = (n12 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n13));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    Integer n15 = new Integer(this.readShort(dataInputStream));
                    metaRecord.AddElement(n15);
                    short s14 = this.readShort(dataInputStream);
                    int n8 = this.readInt(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n16 = n8 & 0xFF;
                    int n7 = (n8 & 0xFF00) >> 8;
                    int n17 = (n8 & 0xFF0000) >> 16;
                    int n10 = (n8 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n16));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n17));
                    metaRecord.AddElement(new Integer(s14));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    int n18 = this.readInt(dataInputStream);
                    int n19 = n18 & 0xFF;
                    int n8 = (n18 & 0xFF00) >> 8;
                    int n9 = (n18 & 0xFF0000) >> 16;
                    int n20 = (n18 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n19));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n9));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    short s15 = this.readShort(dataInputStream);
                    short s16 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s16));
                    metaRecord.AddElement(new Integer(s15));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1336: {
                    int n7;
                    int n9;
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    int n21 = this.readShort(dataInputStream);
                    int[] nArray = new int[n21];
                    int n8 = 0;
                    for (n9 = 0; n9 < n21; ++n9) {
                        nArray[n9] = this.readShort(dataInputStream);
                        n8 += nArray[n9];
                    }
                    metaRecord.AddElement(new Integer(n21));
                    for (n9 = 0; n9 < n21; ++n9) {
                        metaRecord.AddElement(new Integer(nArray[n9]));
                    }
                    n9 = n21 + 1;
                    for (int i = 0; i < n21; ++i) {
                        for (n7 = 0; n7 < nArray[i]; ++n7) {
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        }
                    }
                    this.records.addElement(metaRecord);
                    break;
                }
                case 804: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    int n22 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n22));
                    for (int i = 0; i < n22; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    short s17 = this.readShort(dataInputStream);
                    short s18 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(s18));
                    metaRecord.AddElement(new Integer(s17));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    short s19 = this.readShort(dataInputStream);
                    short s20 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    short s21 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(s21));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(s20));
                    metaRecord.AddElement(new Integer(s19));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    short s22 = this.readShort(dataInputStream);
                    short s23 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    short s24 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    short s25 = this.readShort(dataInputStream);
                    int n10 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n10));
                    metaRecord.AddElement(new Integer(s25));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(s24));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(s23));
                    metaRecord.AddElement(new Integer(s22));
                    this.records.addElement(metaRecord);
                    break;
                }
                default: {
                    metaRecord.numPoints = n6;
                    metaRecord.functionId = n5;
                    for (int i = 0; i < n6; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.addElement(metaRecord);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int n, Object object) {
        int n2;
        for (int i = n2 = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(i);
            if (gdiObject.used) continue;
            gdiObject.Setup(n, object);
            this.lastObjectIdx = i;
            break;
        }
    }

    synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public void addObjectAt(int n, Object object, int n2) {
        if (n2 == 0 || n2 > this.numObjects) {
            this.addObject(n, object);
            return;
        }
        this.lastObjectIdx = n2;
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(i);
            if (i != n2) continue;
            gdiObject.Setup(n, object);
            break;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public GdiObject getObject(int n) {
        return (GdiObject)this.objectVector.elementAt(n);
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.elementAt(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int n) {
        this.vpX = n;
    }

    public void setVpY(int n) {
        this.vpY = n;
    }

    public void setVpW(int n) {
        this.vpW = n;
    }

    public void setVpH(int n) {
        this.vpH = n;
    }
}

