/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] shapePainterArray = new ShapePainter[this.count * 3 / 2 + 1];
            System.arraycopy(this.painters, 0, shapePainterArray, 0, this.count);
            this.painters = shapePainterArray;
        }
        this.painters[this.count++] = shapePainter;
    }

    public ShapePainter getShapePainter(int n) {
        return this.painters[n];
    }

    public int getShapePainterCount() {
        return this.count;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.painters != null) {
            for (int i = 0; i < this.count; ++i) {
                this.painters[i].paint(graphics2D);
            }
        }
    }

    public Shape getPaintedArea() {
        if (this.painters == null) {
            return null;
        }
        Area area = new Area();
        for (int i = 0; i < this.count; ++i) {
            Shape shape = this.painters[i].getPaintedArea();
            if (shape == null) continue;
            area.add(new Area(shape));
        }
        return area;
    }

    public Rectangle2D getPaintedBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.count; ++i) {
            Rectangle2D rectangle2D2 = this.painters[i].getPaintedBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public Shape getSensitiveArea() {
        if (this.painters == null) {
            return null;
        }
        Area area = new Area();
        for (int i = 0; i < this.count; ++i) {
            Shape shape = this.painters[i].getSensitiveArea();
            if (shape == null) continue;
            area.add(new Area(shape));
        }
        return area;
    }

    public Rectangle2D getSensitiveBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.count; ++i) {
            Rectangle2D rectangle2D2 = this.painters[i].getSensitiveBounds2D();
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        if (this.painters != null) {
            for (int i = 0; i < this.count; ++i) {
                this.painters[i].setShape(shape);
            }
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

