/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.svg.DomExtension;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.DoublyIndexedTable;
import org.apache.batik.util.Service;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;

public class ExtensibleSVGDOMImplementation
extends SVGDOMImplementation {
    protected static final DOMImplementation DOM_IMPLEMENTATION = new ExtensibleSVGDOMImplementation();
    protected DoublyIndexedTable customFactories;
    protected List customValueManagers;
    protected List customShorthandManagers;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$dom$svg$DomExtension;

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    public ExtensibleSVGDOMImplementation() {
        Iterator iterator = ExtensibleSVGDOMImplementation.getDomExtensions().iterator();
        while (iterator.hasNext()) {
            DomExtension domExtension = (DomExtension)iterator.next();
            domExtension.registerTags(this);
        }
    }

    public void registerCustomElementFactory(String string, String string2, SVGDOMImplementation.ElementFactory elementFactory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put(string, string2, elementFactory);
    }

    public void registerCustomCSSValueManager(ValueManager valueManager) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList();
        }
        this.customValueManagers.add(valueManager);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager shorthandManager) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList();
        }
        this.customShorthandManagers.add(shorthandManager);
    }

    public CSSEngine createCSSEngine(SVGOMDocument sVGOMDocument, CSSContext cSSContext) {
        ShorthandManager[] shorthandManagerArray;
        ValueManager[] valueManagerArray;
        Parser parser;
        if (this.customValueManagers == null && this.customShorthandManagers == null) {
            return super.createCSSEngine(sVGOMDocument, cSSContext);
        }
        String string = XMLResourceDescriptor.getCSSParserClassName();
        try {
            parser = (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{string}));
        }
        catch (InstantiationException instantiationException) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{string}));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{string}));
        }
        ExtendedParser extendedParser = ExtendedParserWrapper.wrap(parser);
        if (this.customValueManagers == null) {
            valueManagerArray = new ValueManager[]{};
        } else {
            valueManagerArray = new ValueManager[this.customValueManagers.size()];
            shorthandManagerArray = this.customValueManagers.iterator();
            int n = 0;
            while (shorthandManagerArray.hasNext()) {
                valueManagerArray[n++] = (ValueManager)shorthandManagerArray.next();
            }
        }
        if (this.customShorthandManagers == null) {
            shorthandManagerArray = new ShorthandManager[]{};
        } else {
            shorthandManagerArray = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator iterator = this.customShorthandManagers.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                shorthandManagerArray[n++] = (ShorthandManager)iterator.next();
            }
        }
        URL uRL = sVGOMDocument.getURLObject();
        SVGCSSEngine sVGCSSEngine = new SVGCSSEngine(sVGOMDocument, uRL, extendedParser, valueManagerArray, shorthandManagerArray, cSSContext);
        URL uRL2 = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (uRL2 != null) {
            InputSource inputSource = new InputSource(uRL2.toString());
            sVGCSSEngine.setUserAgentStyleSheet(sVGCSSEngine.parseStyleSheet(inputSource, uRL2, "all"));
        }
        sVGOMDocument.setCSSEngine(sVGCSSEngine);
        return sVGCSSEngine;
    }

    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        if ("http://www.w3.org/2000/svg".equals(string)) {
            String string3 = DOMUtilities.getLocalName(string2);
            SVGDOMImplementation.ElementFactory elementFactory = (SVGDOMImplementation.ElementFactory)this.factories.get(string3);
            if (elementFactory == null) {
                throw abstractDocument.createDOMException((short)8, "invalid.element", new Object[]{string, string2});
            }
            return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
        }
        if (string != null) {
            String string4;
            SVGDOMImplementation.ElementFactory elementFactory;
            if (this.customFactories != null && (elementFactory = (SVGDOMImplementation.ElementFactory)this.customFactories.get(string, string4 = DOMUtilities.getLocalName(string2))) != null) {
                return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
            }
            return new GenericElementNS(string.intern(), string2.intern(), abstractDocument);
        }
        return new GenericElement(string2.intern(), abstractDocument);
    }

    protected static synchronized List getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        Iterator iterator = Service.providers(class$org$apache$batik$dom$svg$DomExtension == null ? (class$org$apache$batik$dom$svg$DomExtension = ExtensibleSVGDOMImplementation.class$("org.apache.batik.dom.svg.DomExtension")) : class$org$apache$batik$dom$svg$DomExtension);
        block0: while (iterator.hasNext()) {
            DomExtension domExtension;
            DomExtension domExtension2 = (DomExtension)iterator.next();
            float f = domExtension2.getPriority();
            ListIterator<DomExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(domExtension2);
                continue block0;
            } while (!((domExtension = (DomExtension)listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(domExtension2);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

