/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable;
        if (bl) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            hashTable = this.bubblingListeners;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashTable.put(string, eventListenerList);
        }
        if (!eventListenerList.contains(eventListener)) {
            eventListenerList.add(eventListener);
        }
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string);
        if (eventListenerList != null) {
            eventListenerList.remove(eventListener);
            if (eventListenerList.size() == 0) {
                hashTable.remove(string);
            }
        }
    }

    public static boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) throws EventException {
        NodeEventTarget nodeEventTarget2;
        int n;
        AbstractEvent abstractEvent = (AbstractEvent)event;
        if (abstractEvent == null) {
            return false;
        }
        String string = abstractEvent.getType();
        if (string == null) {
            throw EventSupport.createUnspecifiedEventTypeErr("Event type can't be null");
        }
        abstractEvent.setTarget(nodeEventTarget);
        abstractEvent.stopPropagation(false);
        abstractEvent.preventDefault(false);
        NodeEventTarget[] nodeEventTargetArray = EventSupport.getAncestors(nodeEventTarget);
        abstractEvent.setEventPhase((short)1);
        for (n = 0; n < nodeEventTargetArray.length && !abstractEvent.getStopPropagation(); ++n) {
            nodeEventTarget2 = nodeEventTargetArray[n];
            abstractEvent.setCurrentTarget(nodeEventTarget2);
            EventSupport.fireEventListeners(nodeEventTarget2, abstractEvent, true);
        }
        if (!abstractEvent.getStopPropagation()) {
            abstractEvent.setEventPhase((short)2);
            abstractEvent.setCurrentTarget(nodeEventTarget);
            EventSupport.fireEventListeners(nodeEventTarget, abstractEvent, false);
        }
        if (abstractEvent.getBubbles()) {
            abstractEvent.setEventPhase((short)3);
            for (n = nodeEventTargetArray.length - 1; n >= 0 && !abstractEvent.getStopPropagation(); --n) {
                nodeEventTarget2 = nodeEventTargetArray[n];
                abstractEvent.setCurrentTarget(nodeEventTarget2);
                EventSupport.fireEventListeners(nodeEventTarget2, abstractEvent, false);
            }
        }
        return abstractEvent.getPreventDefault();
    }

    private static void fireEventListeners(NodeEventTarget nodeEventTarget, Event event, boolean bl) {
        String string = event.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl);
        if (eventListenerList == null) {
            return;
        }
        EventListener[] eventListenerArray = eventListenerList.getEventListeners();
        if (eventListenerArray == null) {
            return;
        }
        for (int i = 0; i < eventListenerArray.length; ++i) {
            try {
                eventListenerArray[i].handleEvent(event);
                continue;
            }
            catch (Throwable throwable) {
                System.err.println("In Event");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static NodeEventTarget[] getAncestors(NodeEventTarget object) {
        object = object.getParentNodeEventTarget();
        int n = 0;
        NodeEventTarget[] nodeEventTargetArray = object;
        while (nodeEventTargetArray != null) {
            nodeEventTargetArray = nodeEventTargetArray.getParentNodeEventTarget();
            ++n;
        }
        nodeEventTargetArray = new NodeEventTarget[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            nodeEventTargetArray[n2] = object;
            --n2;
            object = object.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public EventListenerList getEventListeners(String string, boolean bl) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return null;
        }
        return (EventListenerList)hashTable.get(string);
    }

    private static EventException createEventException(short s, String string) {
        return new EventException(s, string);
    }

    private static EventException createUnspecifiedEventTypeErr(String string) {
        return EventSupport.createEventException((short)0, string);
    }
}

