/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;

    protected CSSLexicalUnit(short s, LexicalUnit lexicalUnit) {
        this.lexicalUnitType = s;
        this.previousLexicalUnit = lexicalUnit;
        if (lexicalUnit != null) {
            ((CSSLexicalUnit)lexicalUnit).nextLexicalUnit = this;
        }
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public void setNextLexicalUnit(LexicalUnit lexicalUnit) {
        this.nextLexicalUnit = lexicalUnit;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lexicalUnit) {
        this.previousLexicalUnit = lexicalUnit;
    }

    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    public float getFloatValue() {
        throw new IllegalStateException();
    }

    public String getDimensionUnitText() {
        throw new IllegalStateException();
    }

    public String getFunctionName() {
        throw new IllegalStateException();
    }

    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    public String getStringValue() {
        throw new IllegalStateException();
    }

    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public static CSSLexicalUnit createSimple(short s, LexicalUnit lexicalUnit) {
        return new SimpleLexicalUnit(s, lexicalUnit);
    }

    public static CSSLexicalUnit createInteger(int n, LexicalUnit lexicalUnit) {
        return new IntegerLexicalUnit(n, lexicalUnit);
    }

    public static CSSLexicalUnit createFloat(short s, float f, LexicalUnit lexicalUnit) {
        return new FloatLexicalUnit(s, f, lexicalUnit);
    }

    public static CSSLexicalUnit createDimension(float f, String string, LexicalUnit lexicalUnit) {
        return new DimensionLexicalUnit(f, string, lexicalUnit);
    }

    public static CSSLexicalUnit createFunction(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new FunctionLexicalUnit(string, lexicalUnit, lexicalUnit2);
    }

    public static CSSLexicalUnit createPredefinedFunction(short s, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new PredefinedFunctionLexicalUnit(s, lexicalUnit, lexicalUnit2);
    }

    public static CSSLexicalUnit createString(short s, String string, LexicalUnit lexicalUnit) {
        return new StringLexicalUnit(s, string, lexicalUnit);
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short s, String string, LexicalUnit lexicalUnit) {
            super(s, lexicalUnit);
            this.value = string;
        }

        public String getStringValue() {
            return this.value;
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short s, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
            super(s, lexicalUnit2);
            this.parameters = lexicalUnit;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
            super((short)41, lexicalUnit2);
            this.name = string;
            this.parameters = lexicalUnit;
        }

        public String getFunctionName() {
            return this.name;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float f, String string, LexicalUnit lexicalUnit) {
            super((short)42, lexicalUnit);
            this.value = f;
            this.dimension = string;
        }

        public float getFloatValue() {
            return this.value;
        }

        public String getDimensionUnitText() {
            return this.dimension;
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short s, float f, LexicalUnit lexicalUnit) {
            super(s, lexicalUnit);
            this.value = f;
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int n, LexicalUnit lexicalUnit) {
            super((short)13, lexicalUnit);
            this.value = n;
        }

        public int getIntegerValue() {
            return this.value;
        }
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short s, LexicalUnit lexicalUnit) {
            super(s, lexicalUnit);
        }
    }
}

