/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng;

import com.thaiopensource.relaxng.AbstractSchema;
import com.thaiopensource.relaxng.IncorrectSchemaException;
import com.thaiopensource.relaxng.Schema;
import com.thaiopensource.relaxng.XMLReaderCreator;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import com.thaiopensource.relaxng.impl.IdTypeMapSchema;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.compact.CompactParseable;
import com.thaiopensource.relaxng.parse.sax.SAXParseable;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFactory {
    private XMLReaderCreator xrc = null;
    private ErrorHandler eh = null;
    private DatatypeLibraryFactory dlf = null;
    private boolean checkIdIdref = false;
    private boolean compactSyntax = false;
    private boolean feasible = false;

    public Schema createSchema(InputSource inputSource) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        Parseable parseable = this.compactSyntax ? new CompactParseable(inputSource, this.eh) : new SAXParseable(this.xrc, inputSource, this.eh);
        Pattern pattern = SchemaBuilderImpl.parse(parseable, this.eh, this.dlf, schemaPatternBuilder);
        if (this.feasible) {
            pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
        }
        AbstractSchema abstractSchema = new PatternSchema(schemaPatternBuilder, pattern);
        if (schemaPatternBuilder.hasIdTypes() && this.checkIdIdref) {
            IdTypeMap idTypeMap = new IdTypeMapBuilder(this.eh, pattern).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema abstractSchema2 = this.feasible ? new FeasibleIdTypeMapSchema(idTypeMap) : new IdTypeMapSchema(idTypeMap);
            abstractSchema = new CombineSchema(abstractSchema, abstractSchema2);
        }
        return abstractSchema;
    }

    public void setXMLReaderCreator(XMLReaderCreator xMLReaderCreator) {
        this.xrc = xMLReaderCreator;
    }

    public XMLReaderCreator getXMLReaderCreator() {
        return this.xrc;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.eh;
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.dlf = datatypeLibraryFactory;
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return this.dlf;
    }

    public void setCheckIdIdref(boolean bl) {
        this.checkIdIdref = bl;
    }

    public boolean getCheckIdIdref() {
        return this.checkIdIdref;
    }

    public void setCompactSyntax(boolean bl) {
        this.compactSyntax = bl;
    }

    public boolean getCompactSyntax() {
        return this.compactSyntax;
    }

    public void setFeasible(boolean bl) {
        this.feasible = bl;
    }

    public boolean getFeasible() {
        return this.feasible;
    }
}

