/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class J2eeDataSource
extends AbstractLogEnabled
implements DataSourceComponent {
    public static final String JDBC_NAME = "java:comp/env/jdbc/";
    protected DataSource m_dataSource = null;
    protected String m_user;
    protected String m_password;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_dataSource == null) {
            String contextFactory = configuration.getChild("initial-context-factory").getValue(null);
            String providerUrl = configuration.getChild("provider-url").getValue(null);
            String lookupName = configuration.getChild("lookup-name").getValue(null);
            if (lookupName == null) {
                lookupName = JDBC_NAME + configuration.getChild("dbname").getValue();
            }
            try {
                InitialContext initialContext;
                if (contextFactory == null && providerUrl == null) {
                    initialContext = new InitialContext();
                } else {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    if (contextFactory != null) {
                        props.put("java.naming.factory.initial", contextFactory);
                    }
                    if (providerUrl != null) {
                        props.put("java.naming.provider.url", providerUrl);
                    }
                    initialContext = new InitialContext(props);
                }
                this.m_dataSource = lookupName == null ? (DataSource)initialContext.lookup(lookupName) : (DataSource)initialContext.lookup(lookupName);
            }
            catch (NamingException ne) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Problem with JNDI lookup of datasource", (Throwable)ne);
                }
                throw new ConfigurationException("Could not use JNDI to find datasource", (Throwable)ne);
            }
        }
        this.m_user = configuration.getChild("user").getValue(null);
        this.m_password = configuration.getChild("password").getValue(null);
    }

    public Connection getConnection() throws SQLException {
        if (this.m_dataSource == null) {
            throw new SQLException("Can not access DataSource object");
        }
        if (this.m_user == null || this.m_password == null) {
            return this.m_dataSource.getConnection();
        }
        return this.m_dataSource.getConnection(this.m_user, this.m_password);
    }
}

