/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl.validity;

import java.io.File;
import org.apache.excalibur.source.SourceValidity;

public final class FileTimeStampValidity
implements SourceValidity {
    private long m_timeStamp;
    private File m_file;

    public FileTimeStampValidity(String filename) {
        this(new File(filename));
    }

    public FileTimeStampValidity(File file) {
        this(file, file.lastModified());
    }

    public FileTimeStampValidity(File file, long timeStamp) {
        this.m_file = file;
        this.m_timeStamp = timeStamp;
    }

    public int isValid() {
        return this.m_file.lastModified() == this.m_timeStamp ? 1 : -1;
    }

    public boolean isValid(SourceValidity newValidity) {
        if (newValidity instanceof FileTimeStampValidity) {
            long timeStamp = ((FileTimeStampValidity)newValidity).getTimeStamp();
            return this.m_timeStamp == timeStamp;
        }
        return false;
    }

    public File getFile() {
        return this.m_file;
    }

    public long getTimeStamp() {
        return this.m_timeStamp;
    }

    public String toString() {
        return "FileTimeStampValidity: " + this.m_file.getPath() + ": " + this.m_timeStamp;
    }
}

