/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.VariableSizeBuffer;
import org.apache.avalon.excalibur.pool.Mutex;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractPool
extends AbstractLogEnabled
implements Pool,
ThreadSafe {
    public static final int DEFAULT_POOL_SIZE = 8;
    protected final ObjectFactory m_factory;
    protected List m_active = new ArrayList();
    protected Buffer m_ready = new VariableSizeBuffer();
    protected Mutex m_mutex = new Mutex();
    protected boolean m_initialized = false;
    protected int m_min;

    public AbstractPool(ObjectFactory factory) throws Exception {
        this.m_factory = factory;
        if (!(this instanceof Initializable)) {
            this.initialize();
        }
    }

    protected void initialize() throws Exception {
        this.lock();
        int i = 0;
        while (i < 8) {
            this.m_ready.add((Object)this.newPoolable());
            ++i;
        }
        this.m_initialized = true;
        this.unlock();
    }

    protected final void lock() throws InterruptedException {
        this.m_mutex.acquire();
    }

    protected final void unlock() throws InterruptedException {
        this.m_mutex.release();
    }

    protected Poolable newPoolable() throws Exception {
        Object obj = this.m_factory.newInstance();
        return (Poolable)obj;
    }

    protected void removePoolable(Poolable poolable) {
        block2: {
            try {
                this.m_factory.decommission(poolable);
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("Error decommissioning object", (Throwable)e);
            }
        }
    }

    public final int size() {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            int n = this.m_active.size() + this.m_ready.size();
            return n;
        }
    }

    public abstract Poolable get() throws Exception;

    public abstract void put(Poolable var1);

    protected void internalGrow(int amount) throws Exception {
        int i = 0;
        while (i < amount) {
            block4: {
                try {
                    this.m_ready.add((Object)this.newPoolable());
                }
                catch (Exception e) {
                    if (null == this.getLogger() || !this.getLogger().isDebugEnabled()) break block4;
                    Class createdClass = this.m_factory.getCreatedClass();
                    if (createdClass == null) {
                        this.getLogger().debug("factory created class was null so a new instance could not be created.", (Throwable)e);
                    }
                    this.getLogger().debug(createdClass.getName() + ": could not be instantiated.", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void internalShrink(int amount) throws Exception {
        int i = 0;
        while (i < amount) {
            block4: {
                if (this.m_ready.size() > this.m_min) {
                    try {
                        this.removePoolable((Poolable)this.m_ready.remove());
                    }
                    catch (Exception e) {
                        if (null == this.getLogger() || !this.getLogger().isDebugEnabled()) break block4;
                        this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": improperly decommissioned.", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }
}

