/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private short field_1_value;

    public IntPtg() {
    }

    public IntPtg(byte[] data, int offset) {
        this.setValue(LittleEndian.getShort(data, offset + 1));
    }

    public void setValue(short value) {
        this.field_1_value = value;
    }

    public short getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putShort(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString() {
        return "" + this.getValue();
    }

    static {
        SIZE = 3;
        sid = (byte)30;
    }
}

