/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.avalon.excalibur.monitor.Modifiable;

public abstract class Resource
implements Modifiable {
    protected static final String MODIFIED = "last-modified";
    protected PropertyChangeSupport m_eventSupport = new PropertyChangeSupport(this);
    private final String m_resourceKey;
    protected long m_previousModified = 0L;
    private static final Set m_propertyListeners = Collections.synchronizedSet(new HashSet());

    public Resource(String location) throws Exception {
        this.m_resourceKey = location;
    }

    public final String getResourceKey() {
        return this.m_resourceKey;
    }

    public abstract long lastModified();

    public void testModifiedAfter(long time) {
        long lastModified = this.lastModified();
        if (lastModified > this.m_previousModified || lastModified > time) {
            this.m_eventSupport.firePropertyChange(MODIFIED, new Long(this.m_previousModified), new Long(lastModified));
            this.m_previousModified = lastModified;
        }
    }

    protected void addPropertyChangeListenersFrom(Resource other) {
        PropertyChangeListener[] listeners = m_propertyListeners.toArray(new PropertyChangeListener[0]);
        int i = 0;
        while (i < listeners.length) {
            this.addPropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_eventSupport.addPropertyChangeListener(listener);
        m_propertyListeners.add(listener);
    }

    protected void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_eventSupport.addPropertyChangeListener(property, listener);
        m_propertyListeners.add(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_eventSupport.removePropertyChangeListener(listener);
        m_propertyListeners.remove(listener);
    }

    protected void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_eventSupport.removePropertyChangeListener(property, listener);
        m_propertyListeners.remove(listener);
    }

    public final boolean hasListeners() {
        return this.m_eventSupport.hasListeners(this.getResourceKey());
    }

    protected void removeAllPropertyChangeListeners() {
        PropertyChangeListener[] listeners = m_propertyListeners.toArray(new PropertyChangeListener[0]);
        int i = 0;
        while (i < listeners.length) {
            this.removePropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    protected boolean hasListeners(String property) {
        return this.m_eventSupport.hasListeners(property);
    }
}

