/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

final class LZWDecompressionStringTable {
    private static final int NO_PREFIX = -1;
    private static final int DEFAULT_TABLE_SIZE = 4096;
    protected byte[][] strings_;
    protected int size_ = 0;
    protected int codeSize_;
    protected int tableSize_;

    public LZWDecompressionStringTable(int n) {
        this(n, 4096);
    }

    public LZWDecompressionStringTable(int n, int n2) {
        this.tableSize_ = n2;
        this.codeSize_ = n;
        this.initTable();
    }

    public int addCharString(int n, byte by) {
        if (n == -1) {
            this.strings_[this.size_] = new byte[]{by};
        } else {
            int n2 = this.strings_[n].length + 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.strings_[n], 0, byArray, 0, n2 - 1);
            byArray[n2 - 1] = by;
            this.strings_[this.size_] = byArray;
        }
        return this.size_++;
    }

    public void clearTable() {
        this.size_ = (1 << this.codeSize_) + 2;
    }

    public final boolean contains(int n) {
        return n < this.size_;
    }

    public int expandCode(byte[] byArray, int n, int n2, int n3) {
        int n4 = byArray.length - n;
        int n5 = this.strings_[n2].length - n3;
        int n6 = n4 > n5 ? n5 : n4;
        System.arraycopy(this.strings_[n2], n3, byArray, n, n6);
        return n5 > n6 ? -(n6 + n3) : n6;
    }

    protected void initTable() {
        this.strings_ = new byte[this.tableSize_][];
        int n = (1 << this.codeSize_) + 2;
        int n2 = 0;
        while (n2 < n) {
            this.addCharString(-1, (byte)n2);
            ++n2;
        }
    }
}

