/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.dom.DOMHandler;
import org.apache.excalibur.xml.dom.DOMHandlerFactory;
import org.apache.excalibur.xml.dom.DefaultDOMHandler;
import org.w3c.dom.Document;

public class DefaultDOMHandlerFactory
extends AbstractLogEnabled
implements DOMHandlerFactory,
Configurable,
Initializable,
Component,
ThreadSafe {
    private final SAXTransformerFactory m_transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private final DocumentBuilderFactory m_documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder m_documentBuilder;
    private boolean m_ignoreWhitespaces;
    private boolean m_ignoreComments;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_ignoreWhitespaces = configuration.getChild("ignore-whitespaces").getValueAsBoolean(false);
        this.m_ignoreComments = configuration.getChild("ignore-comments").getValueAsBoolean(false);
    }

    public void initialize() throws Exception {
        this.m_documentBuilder = this.m_documentBuilderFactory.newDocumentBuilder();
    }

    public DOMHandler createDOMHandler() throws Exception {
        Document document = this.m_documentBuilder.newDocument();
        TransformerHandler transformerHandler = this.m_transformerFactory.newTransformerHandler();
        return new DefaultDOMHandler(transformerHandler, document, this.m_ignoreComments, this.m_ignoreWhitespaces);
    }
}

