/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.CascadingThrowable;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.log.ExtensiblePatternFormatter;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;

public class CocoonLogFormatter
extends ExtensiblePatternFormatter {
    protected static final int TYPE_CLASS = 9;
    protected static final int TYPE_URI = 10;
    protected static final int TYPE_THREAD = 11;
    protected static final String TYPE_CLASS_STR = "class";
    protected static final String TYPE_CLASS_SHORT_STR = "short";
    protected static final String TYPE_URI_STR = "uri";
    protected static final String TYPE_THREAD_STR = "thread";
    protected final SimpleDateFormat dateFormatter = new SimpleDateFormat("(yyyy-MM-dd) HH:mm.ss:SSS");
    private Class logkitClass = class$org$apache$avalon$framework$logger$LogKitLogger == null ? (class$org$apache$avalon$framework$logger$LogKitLogger = CocoonLogFormatter.class$("org.apache.avalon.framework.logger.LogKitLogger")) : class$org$apache$avalon$framework$logger$LogKitLogger;
    private Class loggerClass = class$org$apache$log$Logger == null ? (class$org$apache$log$Logger = CocoonLogFormatter.class$("org.apache.log.Logger")) : class$org$apache$log$Logger;
    private CallStack callStack = new CallStack();
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogKitLogger;
    static /* synthetic */ Class class$org$apache$log$Logger;

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_URI_STR)) {
            return 10;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 11;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, ExtensiblePatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
            case 10: {
                return this.getURI(event.getContextMap());
            }
            case 11: {
                return this.getThread(event.getContextMap());
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getClass(String format) {
        Class[] stack = this.callStack.get();
        int i = stack.length - 1;
        while (i >= 0) {
            if (this.logkitClass.isAssignableFrom(stack[i]) || this.loggerClass.isAssignableFrom(stack[i])) {
                int pos;
                String className = stack[i + 1].getName();
                if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(format) && (pos = className.lastIndexOf(46)) >= 0) {
                    className = className.substring(pos + 1);
                }
                return className;
            }
            --i;
        }
        return "Unknown-class";
    }

    private String getURI(ContextMap ctxMap) {
        Request request;
        Object context;
        String result = "Unknown-URI";
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            result = request.getRequestURI();
        }
        return result;
    }

    private String getThread(ContextMap ctxMap) {
        if (ctxMap != null && ctxMap.get("threadName") != null) {
            return (String)ctxMap.get("threadName");
        }
        return "Unknown-thread";
    }

    protected String getStackTrace(Throwable throwable, String format) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getStackTrace(throwable, format));
        if (throwable instanceof CascadingThrowable) {
            Throwable t = ((CascadingThrowable)throwable).getCause();
            sb.append(this.getStackTrace(t, format));
        }
        return sb.toString();
    }

    protected String getTime(long time, String format) {
        return this.dateFormatter.format(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CallStack
    extends SecurityManager {
        public Class[] get() {
            return this.getClassContext();
        }
    }
}

