/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VelocityGenerator
extends ComposerGenerator
implements Initializable,
Configurable,
LogSystem {
    private static final String CONTEXT_RESOLVER_KEY = "resolver";
    private static final String CONTEXT_SOURCE_CACHE_KEY = "source-cache";
    private List objectExports;
    private VelocityEngine tmplEngine;
    private DefaultContext resolverContext;
    private VelocityContext velocityContext;
    private boolean activeFlag;
    static /* synthetic */ Class class$org$apache$cocoon$generation$VelocityGenerator$TemplateLoader;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.resolverContext = new DefaultContext();
        this.objectExports = new ArrayList();
        this.tmplEngine = new VelocityEngine();
        this.tmplEngine.setProperty("runtime.log.logsystem", (Object)this);
        this.tmplEngine.setProperty("cocoon.resource.loader.class", (Object)(class$org$apache$cocoon$generation$VelocityGenerator$TemplateLoader == null ? (class$org$apache$cocoon$generation$VelocityGenerator$TemplateLoader = VelocityGenerator.class$("org.apache.cocoon.generation.VelocityGenerator$TemplateLoader")) : class$org$apache$cocoon$generation$VelocityGenerator$TemplateLoader).getName());
        this.tmplEngine.setProperty("cocoon.resource.loader.cache", (Object)configuration.getAttribute("usecache", "false"));
        this.tmplEngine.setProperty("cocoon.resource.loader.modificationCheckInterval", (Object)configuration.getAttribute("checkInterval", "0"));
        this.tmplEngine.setProperty("cocoon.resource.loader.context", (Object)this.resolverContext);
        Configuration[] properties = configuration.getChildren("property");
        int i = 0;
        while (i < properties.length) {
            Configuration c = properties[i];
            String name = c.getAttribute("name");
            if (name.startsWith("runtime.log") || name.indexOf(".resource.loader.") != -1) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("ignoring disallowed property '" + name + "'.");
                }
            } else {
                this.tmplEngine.setProperty(name, (Object)c.getAttribute("value"));
            }
            ++i;
        }
        ArrayList<String> resourceLoaders = new ArrayList<String>();
        Configuration[] loaders = configuration.getChildren("resource-loader");
        int i2 = 0;
        while (i2 < loaders.length) {
            Configuration loader = loaders[i2];
            String name = loader.getAttribute("name");
            if (name.equals("cocoon")) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("'cocoon' resource loader already defined.");
                }
            } else {
                resourceLoaders.add(name);
                String prefix = name + ".resource.loader.";
                String type = loader.getAttribute("class");
                this.tmplEngine.setProperty(prefix + "class", (Object)type);
                Configuration[] loaderProperties = loader.getChildren("property");
                int j = 0;
                while (i2 < loaderProperties.length) {
                    Configuration c = loaderProperties[j];
                    String propName = c.getAttribute("name");
                    this.tmplEngine.setProperty(prefix + propName, (Object)c.getAttribute("value"));
                    ++j;
                }
            }
            ++i2;
        }
        StringBuffer buffer = new StringBuffer("cocoon");
        Iterator it = resourceLoaders.iterator();
        while (it.hasNext()) {
            buffer.append(',');
            buffer.append((String)it.next());
        }
        this.tmplEngine.setProperty("resource.loader", (Object)buffer.toString());
        Configuration[] exports = configuration.getChildren("export-object");
        int i3 = 0;
        while (i3 < exports.length) {
            Configuration c = exports[i3];
            ObjectExport export = new ObjectExport();
            export.key = c.getAttribute("key");
            export.name = c.getAttribute("name");
            this.objectExports.add(export);
            ++i3;
        }
    }

    public void initialize() throws Exception {
        this.tmplEngine.init();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        if (this.activeFlag) {
            throw new IllegalStateException("setup called on recyclable sitemap component before properly recycling previous state");
        }
        super.setup(resolver, objectModel, src, params);
        this.resolverContext.put((Object)CONTEXT_RESOLVER_KEY, (Object)resolver);
        this.resolverContext.put((Object)CONTEXT_SOURCE_CACHE_KEY, new HashMap());
        this.velocityContext = new VelocityContext();
        this.velocityContext.put("template", (Object)src);
        this.velocityContext.put("request", (Object)ObjectModelHelper.getRequest(objectModel));
        this.velocityContext.put("response", (Object)ObjectModelHelper.getResponse(objectModel));
        this.velocityContext.put("context", (Object)ObjectModelHelper.getContext(objectModel));
        this.velocityContext.put("parameters", (Object)params);
        Iterator it = this.objectExports.iterator();
        while (it.hasNext()) {
            ObjectExport export = (ObjectExport)it.next();
            Object object = objectModel.get(export.key);
            if (object != null) {
                this.velocityContext.put(export.name, object);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("exporting object under key '" + export.key + "' to velocity context with name '" + export.name + "'.");
                continue;
            }
            if (!this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("unable to export object under key '" + export.key + "' to velocity context.");
        }
        this.activeFlag = true;
    }

    public void recycle() {
        this.activeFlag = false;
        try {
            Map sourceCache = (Map)this.resolverContext.get((Object)CONTEXT_SOURCE_CACHE_KEY);
            Iterator it = sourceCache.values().iterator();
            while (it.hasNext()) {
                ((Source)it.next()).recycle();
            }
        }
        catch (ContextException contextException) {
            // empty catch block
        }
        this.velocityContext = null;
        super.recycle();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (!this.activeFlag) {
            throw new IllegalStateException("generate called on sitemap component before setup.");
        }
        Parser parser = null;
        try {
            try {
                parser = (Parser)this.manager.lookup(Parser.ROLE);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Processing File: " + this.source);
                }
                StringWriter w = new StringWriter();
                this.tmplEngine.mergeTemplate(this.source, (Context)this.velocityContext, (Writer)w);
                InputSource xmlInput = new InputSource(new StringReader(w.toString()));
                parser.parse(xmlInput, (ContentHandler)this.xmlConsumer);
            }
            catch (IOException e) {
                this.getLogger().warn("VelocityGenerator.generate()", (Throwable)e);
                throw new ResourceNotFoundException("Could not get Resource for VelocityGenerator", e);
            }
            catch (SAXException e) {
                this.getLogger().error("VelocityGenerator.generate()", (Throwable)e);
                throw e;
            }
            catch (ComponentException e) {
                this.getLogger().error("Could not get parser", (Throwable)e);
                throw new ProcessingException("Exception in VelocityGenerator.generate()", e);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLogger().error("Could not get parser", (Throwable)e);
                throw new ProcessingException("Exception in VelocityGenerator.generate()", e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public void logVelocityMessage(int level, String message) {
        Logger logger = this.getLogger();
        switch (level) {
            case 2: {
                logger.warn(message);
                break;
            }
            case 1: {
                logger.info(message);
                break;
            }
            case 0: {
                logger.debug(message);
                break;
            }
            case 3: {
                logger.error(message);
                break;
            }
            default: {
                logger.info(message);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectExport {
        public String key;
        public String name;

        private ObjectExport() {
        }
    }

    public static class TemplateLoader
    extends ResourceLoader {
        private org.apache.avalon.framework.context.Context resolverContext;

        public void init(ExtendedProperties config2) {
            this.resolverContext = (org.apache.avalon.framework.context.Context)config2.get((Object)"context");
            if (this.resolverContext == null) {
                throw new IllegalArgumentException("Runtime Cocoon resolver context not specified in resource loader configuration.");
            }
        }

        public InputStream getResourceStream(String systemId) throws org.apache.velocity.exception.ResourceNotFoundException {
            try {
                return this.resolveSource(systemId).getInputStream();
            }
            catch (org.apache.velocity.exception.ResourceNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new org.apache.velocity.exception.ResourceNotFoundException("Unable to resolve source: " + ex);
            }
        }

        public boolean isSourceModified(Resource resource) {
            long lastModified = 0L;
            try {
                lastModified = this.resolveSource(resource.getName()).getLastModified();
            }
            catch (Exception ex) {
                this.rsvc.warn((Object)("Unable to determine last modified for resource: " + resource.getName() + ": " + ex));
            }
            return lastModified > 0L ? lastModified != resource.getLastModified() : true;
        }

        public long getLastModified(Resource resource) {
            long lastModified = 0L;
            try {
                lastModified = this.resolveSource(resource.getName()).getLastModified();
            }
            catch (Exception ex) {
                this.rsvc.warn((Object)("Unable to determine last modified for resource: " + resource.getName() + ": " + ex));
            }
            return lastModified;
        }

        private Source resolveSource(String systemId) throws org.apache.velocity.exception.ResourceNotFoundException {
            Map sourceCache;
            try {
                sourceCache = (Map)this.resolverContext.get((Object)VelocityGenerator.CONTEXT_SOURCE_CACHE_KEY);
            }
            catch (ContextException ignore) {
                throw new org.apache.velocity.exception.ResourceNotFoundException("Runtime Cocoon source cache not specified in resource loader resolver context.");
            }
            Source source = (Source)sourceCache.get(systemId);
            if (source == null) {
                try {
                    SourceResolver resolver = (SourceResolver)this.resolverContext.get((Object)VelocityGenerator.CONTEXT_RESOLVER_KEY);
                    source = resolver.resolve(systemId);
                }
                catch (ContextException ex) {
                    throw new org.apache.velocity.exception.ResourceNotFoundException("No Cocoon source resolver associated with current request.");
                }
                catch (Exception ex) {
                    throw new org.apache.velocity.exception.ResourceNotFoundException("Unable to resolve source: " + ex);
                }
            }
            sourceCache.put(systemId, source);
            return source;
        }
    }
}

