/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;

public class PipelineNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements ThreadSafe {
    protected boolean hasParameters() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ProcessingNode buildNode(Configuration config2) throws Exception {
        PipelineNode node = new PipelineNode(config2);
        this.treeBuilder.setupNode(node, config2);
        node.setInternalOnly(config2.getAttributeAsBoolean("internal-only", false));
        HandleErrorsNode error404Handler = null;
        HandleErrorsNode error500Handler = null;
        Configuration[] childConfigs = config2.getChildren();
        ArrayList<ProcessingNode> children = new ArrayList<ProcessingNode>();
        int i = 0;
        while (i < childConfigs.length) {
            Configuration childConfig = childConfigs[i];
            if (this.isChild(childConfig)) {
                ProcessingNodeBuilder builder = this.treeBuilder.createNodeBuilder(childConfig);
                if (builder instanceof HandleErrorsNodeBuilder) {
                    HandleErrorsNode handler = (HandleErrorsNode)builder.buildNode(childConfig);
                    int type = handler.getStatusCode();
                    if (type == 404 && error404Handler != null || type == 500 && error500Handler != null) {
                        String msg = "Duplicate handle-errors at " + handler.getLocation();
                        this.getLogger().error(msg);
                        throw new ConfigurationException(msg);
                    }
                    if (type == 404) {
                        error404Handler = handler;
                    } else {
                        if (type != 500) {
                            String msg = "Unknown handle-errors type (" + type + ") at " + handler.getLocation();
                            this.getLogger().error(msg);
                            throw new ConfigurationException(msg);
                        }
                        error500Handler = handler;
                    }
                } else {
                    children.add(builder.buildNode(childConfig));
                }
            }
            ++i;
        }
        node.setChildren(AbstractParentProcessingNodeBuilder.toNodeArray(children));
        node.set404Handler(error404Handler);
        node.set500Handler(error500Handler);
        return node;
    }
}

