/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.components.store.StoreJanitor;
import org.apache.cocoon.util.ClassUtils;

public final class MRUMemoryStore
extends AbstractLoggable
implements Store,
Parameterizable,
Composable,
Disposable,
ThreadSafe {
    private int maxobjects;
    private boolean persistent;
    private Hashtable cache;
    private LinkedList mrulist;
    private Store persistentStore;
    private StoreJanitor storeJanitor;
    private ComponentManager manager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Looking up org.apache.cocoon.components.store.Store/PersistentCache");
            this.getLogger().debug("Looking up org.apache.cocoon.components.store.StoreJanitor");
        }
        this.persistentStore = (Store)manager.lookup("org.apache.cocoon.components.store.Store/PersistentCache");
        this.storeJanitor = (StoreJanitor)manager.lookup("org.apache.cocoon.components.store.StoreJanitor");
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.maxobjects = params.getParameterAsInteger("maxobjects", 100);
        this.persistent = params.getParameterAsBoolean("use-persistent-cache", false);
        if (this.maxobjects < 1) {
            throw new ParameterException("MRUMemoryStore maxobjects must be at least 1!");
        }
        this.cache = new Hashtable((int)((double)this.maxobjects * 1.2));
        this.mrulist = new LinkedList();
        this.storeJanitor.register(this);
    }

    public void dispose() {
        if (this.manager != null) {
            this.getLogger().debug("Disposing component!");
            if (this.storeJanitor != null) {
                this.storeJanitor.unregister(this);
            }
            this.manager.release((Component)this.storeJanitor);
            this.storeJanitor = null;
            if (this.persistent) {
                this.getLogger().debug("Final cache size: " + this.cache.size());
                Enumeration enumeration = this.cache.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    if (key == null) continue;
                    try {
                        Object value = this.cache.remove(key);
                        if (!this.checkSerializable(value)) continue;
                        this.persistentStore.store(this.getFileName(key.toString()), value);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("Error in dispose()", (Throwable)ioe);
                    }
                }
            }
            this.manager.release((Component)this.persistentStore);
            this.persistentStore = null;
        }
        this.manager = null;
    }

    public synchronized void store(Object key, Object value) {
        this.hold(key, value);
    }

    public synchronized void hold(Object key, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Holding object in memory:");
            this.getLogger().debug("  key: " + key);
            this.getLogger().debug("  value: " + value);
        }
        while (this.mrulist.size() >= this.maxobjects) {
            this.free();
        }
        this.cache.put(key, value);
        this.mrulist.remove(key);
        this.mrulist.addFirst(key);
    }

    public synchronized Object get(Object key) {
        Object value = this.cache.get(key);
        if (value != null) {
            this.mrulist.remove(key);
            this.mrulist.addFirst(key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found key: " + key.toString());
            }
            return value;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found key: " + key.toString());
        }
        if (this.persistent && (value = this.persistentStore.get(this.getFileName(key.toString()))) != null) {
            try {
                if (!this.cache.containsKey(key)) {
                    this.hold(key, value);
                }
                return value;
            }
            catch (Exception e) {
                this.getLogger().error("Error in get()!", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public synchronized void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing object from store");
            this.getLogger().debug("  key: " + key);
        }
        this.cache.remove(key);
        this.mrulist.remove(key);
        if (this.persistent && key != null) {
            this.persistentStore.remove(this.getFileName(key.toString()));
        }
    }

    public synchronized boolean containsKey(Object key) {
        if (this.persistent) {
            return this.cache.containsKey(key) || this.persistentStore.containsKey(key);
        }
        return this.cache.containsKey(key);
    }

    public synchronized Enumeration keys() {
        return this.cache.keys();
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized void free() {
        try {
            if (this.cache.size() > 0) {
                Object key = this.mrulist.removeLast();
                Object value = this.cache.remove(key);
                if (value == null) {
                    this.getLogger().warn("Concurrency condition in free()");
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Freeing cache.");
                    this.getLogger().debug("  key: " + key);
                    this.getLogger().debug("  value: " + value);
                }
                if (this.persistent && this.checkSerializable(value)) {
                    try {
                        this.persistentStore.store(this.getFileName(key.toString()), value);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error storing object on fs", (Throwable)e);
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            this.getLogger().warn("Concurrency error in free()", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("Error in free()", (Throwable)e);
        }
    }

    private boolean checkSerializable(Object object) {
        if (object == null) {
            return false;
        }
        try {
            String clazz = object.getClass().getName();
            return clazz.equals("org.apache.cocoon.caching.CachedEventObject") || clazz.equals("org.apache.cocoon.caching.CachedStreamObject") || ClassUtils.implementsInterface(clazz, "org.apache.cocoon.caching.CacheValidity");
        }
        catch (Exception e) {
            this.getLogger().error("Error in checkSerializable()!", (Throwable)e);
            return false;
        }
    }

    private String getFileName(String key) {
        return URLEncoder.encode(key.toString());
    }
}

