/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.request.multipart;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.components.request.multipart.FilePartArray;
import org.apache.cocoon.components.request.multipart.FilePartFile;
import org.apache.cocoon.components.request.multipart.MultipartException;
import org.apache.cocoon.components.request.multipart.TokenStream;

public class MultipartParser
extends Hashtable {
    private static final int FILE_BUFFER_SIZE = 4096;
    private static final int INLINE_BUFFER_SIZE = 256;
    private static final int MAX_BOUNDARY_SIZE = 128;
    private boolean saveUploadedFilesToDisk;
    private File uploadDirectory = null;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private int maxUploadSize;
    private String characterEncoding;

    public MultipartParser(HttpServletRequest request, boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize) throws IOException, MultipartException {
        this.saveUploadedFilesToDisk = saveUploadedFilesToDisk;
        this.uploadDirectory = uploadDirectory;
        this.allowOverwrite = allowOverwrite;
        this.silentlyRename = silentlyRename;
        this.maxUploadSize = maxUploadSize;
        this.characterEncoding = request.getCharacterEncoding();
        if (this.characterEncoding == null) {
            this.characterEncoding = "ISO-8859-1";
        }
        if (request.getContentLength() > maxUploadSize) {
            throw new IOException("Content length exceeds maximum upload size");
        }
        this.parseMultiPart(new TokenStream(new PushbackInputStream(new BufferedInputStream((InputStream)request.getInputStream()), 128)), this.getBoundary(request.getContentType()));
    }

    private void parseMultiPart(TokenStream ts, String boundary) throws IOException, MultipartException {
        ts.setBoundary(boundary.getBytes());
        ts.read();
        ts.setBoundary(("\r\n" + boundary).getBytes());
        while (ts.getState() == -2) {
            ts.nextPart();
            this.parsePart(ts);
        }
        if (ts.getState() != -3) {
            throw new MultipartException("Malformed stream");
        }
    }

    private void parsePart(TokenStream ts) throws IOException, MultipartException {
        block9: {
            Hashtable headers = new Hashtable();
            headers = this.readHeaders(ts);
            try {
                if (headers.containsKey("filename")) {
                    if (!"".equals(headers.get("filename"))) {
                        this.parseFilePart(ts, headers);
                    } else {
                        byte[] buf = new byte[32];
                        while (ts.getState() == -5) {
                            ts.read(buf);
                        }
                    }
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().equals("form-data")) {
                    this.parseInlinePart(ts, headers);
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().indexOf("multipart") > -1) {
                    this.parseMultiPart(new TokenStream(ts, 128), "--" + (String)headers.get("boundary"));
                    ts.read();
                    break block9;
                }
                throw new MultipartException("Unknown part type");
            }
            catch (IOException e) {
                throw new MultipartException("Malformed stream: " + e.getMessage());
            }
            catch (NullPointerException e) {
                throw new MultipartException("Malformed header");
            }
        }
    }

    private void parseFilePart(TokenStream in, Hashtable headers) throws IOException, MultipartException {
        byte[] buf = new byte[4096];
        OutputStream out = null;
        File file = null;
        if (!this.saveUploadedFilesToDisk) {
            out = new ByteArrayOutputStream();
        } else {
            String fileName = (String)headers.get("filename");
            fileName = File.separatorChar == '\\' ? fileName.replace('/', '\\') : fileName.replace('\\', '/');
            String filePath = this.uploadDirectory.getPath() + File.separator;
            fileName = new File(fileName).getName();
            file = new File(filePath + fileName);
            if (file.exists() && !this.allowOverwrite) {
                if (this.silentlyRename) {
                    int c = 0;
                    while ((file = new File(filePath + c++ + "_" + fileName)).exists()) {
                    }
                } else {
                    throw new MultipartException("Duplicate file " + file.getName() + ".");
                }
            }
            out = new FileOutputStream(file);
        }
        int read = 0;
        while (in.getState() == -5) {
            read = in.read(buf);
            ((OutputStream)out).write(buf, 0, read);
        }
        ((OutputStream)out).close();
        if (file == null) {
            byte[] bytes = out.toByteArray();
            this.put(headers.get("name"), new FilePartArray(headers, new ByteArrayInputStream(bytes)));
        } else {
            this.put(headers.get("name"), new FilePartFile(headers, file));
        }
    }

    private void parseInlinePart(TokenStream in, Hashtable headers) throws IOException {
        byte[] buf = new byte[256];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringBuffer value = new StringBuffer();
        while (in.getState() == -5) {
            int read = in.read(buf);
            value.append(new String(buf, 0, read, this.characterEncoding));
        }
        String field = (String)headers.get("name");
        Vector<String> v = (Vector<String>)this.get(field);
        if (v == null) {
            v = new Vector<String>();
            this.put(field, v);
        }
        v.add(value.toString());
    }

    private Hashtable readHeaders(TokenStream in) throws IOException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        String hdrline = this.readln(in);
        while (!"".equals(hdrline)) {
            StringTokenizer tokenizer = new StringTokenizer(hdrline);
            headers.put(tokenizer.nextToken(" :").toLowerCase(), tokenizer.nextToken(" :;"));
            while (tokenizer.hasMoreTokens()) {
                headers.put(tokenizer.nextToken(" ;=\""), tokenizer.hasMoreTokens() ? tokenizer.nextToken("=\"") : "");
            }
            hdrline = this.readln(in);
        }
        return headers;
    }

    private String getBoundary(String hdr) {
        int start = hdr.toLowerCase().indexOf("boundary=");
        if (start > -1) {
            return "--" + hdr.substring(start + 9);
        }
        return null;
    }

    private String readln(TokenStream in) throws IOException {
        StringBuffer out = new StringBuffer();
        int b = in.read();
        while (b != -1 && b != 13) {
            out.append((char)b);
            b = in.read();
        }
        if (b == 13) {
            in.read();
        }
        return out.toString();
    }
}

