/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.profiler.Profiler;
import org.apache.cocoon.components.profiler.ProfilerResult;
import org.apache.cocoon.generation.ComposerGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProfilerGenerator
extends ComposerGenerator
implements Recyclable,
Composable,
Disposable {
    protected static final String namespace = "http://apache.org/cocoon/profiler/1.0";
    private Profiler profiler;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        try {
            this.profiler = (Profiler)this.manager.lookup("org.apache.cocoon.components.profiler.Profiler");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        if (this.profiler != null) {
            this.manager.release((Component)this.profiler);
            this.profiler = null;
        }
        super.dispose();
    }

    public void generate() throws SAXException {
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", namespace);
        this.generate(this.contentHandler);
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private void generate(ContentHandler ch) throws SAXException {
        String dateTime = DateFormat.getDateTimeInstance().format(new Date());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(namespace, "date", "date", "CDATA", dateTime);
        ch.startElement(namespace, "profilerinfo", "profilerinfo", atts);
        Collection results = this.profiler.getResults();
        Iterator i = results.iterator();
        while (i.hasNext()) {
            this.generateResult(ch, (ProfilerResult)i.next());
        }
        ch.endElement(namespace, "profilerinfo", "profilerinfo");
    }

    private void generateResult(ContentHandler ch, ProfilerResult result) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        int count = result.getCount();
        String[] roles = result.getRoles();
        String[] source = result.getSources();
        long[] avgTime = result.getTotalTime();
        long avgTotal = 0L;
        int i = 0;
        while (i < avgTime.length) {
            avgTotal += avgTime[i];
            ++i;
        }
        atts.addAttribute(namespace, "uri", "uri", "CDATA", result.getURI());
        atts.addAttribute(namespace, "count", "count", "CDATA", Integer.toString(result.getCount()));
        atts.addAttribute(namespace, "time", "time", "CDATA", Long.toString(avgTotal));
        ch.startElement(namespace, "pipeline", "pipeline", atts);
        atts.clear();
        if (count > 0) {
            atts.addAttribute(namespace, "time", "time", "CDATA", Long.toString(avgTotal / (long)count));
            ch.startElement(namespace, "average", "average", atts);
            atts.clear();
            int i2 = 0;
            while (i2 < roles.length) {
                if (roles[i2] != null) {
                    atts.addAttribute(namespace, "role", "role", "CDATA", roles[i2]);
                }
                if (source[i2] != null) {
                    atts.addAttribute(namespace, "source", "source", "CDATA", source[i2]);
                }
                atts.addAttribute(namespace, "time", "time", "CDATA", Long.toString(avgTime[i2] / (long)count));
                ch.startElement(namespace, "element", "element", atts);
                atts.clear();
                ch.endElement(namespace, "element", "element");
                ++i2;
            }
            ch.endElement(namespace, "average", "average");
            long[][] last = result.getLastTimes();
            int j = 0;
            while (j < last.length) {
                if (last[j] != null) {
                    long[] curTime = last[j];
                    long curTotal = 0L;
                    int i3 = 0;
                    while (i3 < curTime.length) {
                        curTotal += curTime[i3];
                        ++i3;
                    }
                    atts.addAttribute(namespace, "time", "time", "CDATA", Long.toString(curTotal));
                    ch.startElement(namespace, "result", "result", atts);
                    atts.clear();
                    int i4 = 0;
                    while (i4 < roles.length) {
                        if (roles[i4] != null) {
                            atts.addAttribute(namespace, "role", "role", "CDATA", roles[i4]);
                        }
                        if (source[i4] != null) {
                            atts.addAttribute(namespace, "source", "source", "CDATA", source[i4]);
                        }
                        atts.addAttribute(namespace, "time", "time", "CDATA", Long.toString(curTime[i4]));
                        ch.startElement(namespace, "element", "element", atts);
                        atts.clear();
                        ch.endElement(namespace, "element", "element");
                        ++i4;
                    }
                    ch.endElement(namespace, "result", "result");
                }
                ++j;
            }
        }
        ch.endElement(namespace, "pipeline", "pipeline");
    }
}

