/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.OutputComponentSelector;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;

public abstract class AbstractStreamPipeline
extends AbstractLoggable
implements StreamPipeline,
Disposable {
    protected EventPipeline eventPipeline;
    protected Reader reader;
    protected Parameters readerParam;
    protected String readerSource;
    protected String readerMimeType;
    protected String sitemapReaderMimeType;
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    protected String sitemapSerializerMimeType;
    protected OutputComponentSelector readerSelector;
    protected OutputComponentSelector serializerSelector;
    protected ComponentManager manager;
    protected ComponentManager newManager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.newManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.newManager = manager;
    }

    public void setEventPipeline(EventPipeline eventPipeline) throws Exception {
        if (this.eventPipeline != null) {
            throw new ProcessingException("EventPipeline already set. You can only select one EventPipeline ");
        }
        this.eventPipeline = eventPipeline;
    }

    public EventPipeline getEventPipeline() {
        return this.eventPipeline;
    }

    public void setReader(String role, String source, Parameters param) throws Exception {
        this.setReader(role, source, param, null);
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws Exception {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. You can only select one Reader (" + role + ")");
        }
        this.readerSelector = (OutputComponentSelector)this.newManager.lookup("org.apache.cocoon.reading.ReaderSelector");
        this.reader = (Reader)this.readerSelector.select(role);
        this.readerSource = source;
        this.readerParam = param;
        this.readerMimeType = mimeType;
        this.sitemapReaderMimeType = this.readerSelector.getMimeTypeForHint(role);
    }

    public void setSerializer(String role, String source, Parameters param) throws Exception {
        this.setSerializer(role, source, param, null);
    }

    public void setSerializer(String role, String source, Parameters param, String mimeType) throws Exception {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. You can only select one Serializer (" + role + ")");
        }
        this.serializerSelector = (OutputComponentSelector)this.newManager.lookup("org.apache.cocoon.serialization.SerializerSelector");
        this.serializer = (Serializer)this.serializerSelector.select(role);
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.sitemapSerializerMimeType = this.serializerSelector.getMimeTypeForHint(role);
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (this.reader != null) {
            return this.processReader(environment);
        }
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        this.setupPipeline(environment);
        this.connectPipeline();
        try {
            if (this.serializer.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.setOutputStream(os);
                this.eventPipeline.process(environment);
                byte[] data = os.toByteArray();
                environment.setContentLength(data.length);
                environment.getOutputStream().write(data);
            } else {
                this.serializer.setOutputStream(environment.getOutputStream());
                this.eventPipeline.process(environment);
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().debug("Exception in process", (Throwable)e);
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(environment, environment.getObjectModel(), this.readerSource, this.readerParam);
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else if (this.readerMimeType != null) {
                environment.setContentType(this.readerMimeType);
            } else {
                environment.setContentType(this.sitemapReaderMimeType);
            }
            long lastModified = this.reader.getLastModified();
            if (lastModified != 0L && !environment.isResponseModified(lastModified)) {
                environment.setResponseIsNotModified();
                return true;
            }
            if (this.reader.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.reader.setOutputStream(os);
                this.reader.generate();
                byte[] data = os.toByteArray();
                environment.setContentLength(data.length);
                environment.getOutputStream().write(data);
            } else {
                this.reader.setOutputStream(environment.getOutputStream());
                this.reader.generate();
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Error reading resource", e);
        }
        return true;
    }

    protected boolean checkPipeline() {
        if (this.eventPipeline == null) {
            return false;
        }
        return this.serializer != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        String mimeType = this.serializer.getMimeType();
        if (mimeType != null) {
            environment.setContentType(mimeType);
        } else if (this.serializerMimeType != null) {
            environment.setContentType(this.serializerMimeType);
        } else if (this.sitemapSerializerMimeType != null) {
            environment.setContentType(this.sitemapSerializerMimeType);
        } else {
            String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
            this.getLogger().error(message);
            throw new ProcessingException(message);
        }
    }

    protected void connectPipeline() throws ProcessingException {
        EventPipeline prev = this.eventPipeline;
        prev.setConsumer(this.serializer);
    }

    public void dispose() {
    }

    public void recycle() {
        try {
            block5: {
                try {
                    if (this.readerSelector != null) {
                        this.readerSelector.release(this.reader);
                    }
                    this.eventPipeline = null;
                    if (this.serializerSelector == null) break block5;
                    this.serializerSelector.release(this.serializer);
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to release components from AbstractStreamPipeline.", (Throwable)e);
                    Object var3_2 = null;
                    this.readerSelector = null;
                    this.reader = null;
                    this.serializerSelector = null;
                    this.serializer = null;
                    this.eventPipeline = null;
                }
            }
            Object var3_1 = null;
            this.readerSelector = null;
            this.reader = null;
            this.serializerSelector = null;
            this.serializer = null;
            this.eventPipeline = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readerSelector = null;
            this.reader = null;
            this.serializerSelector = null;
            this.serializer = null;
            this.eventPipeline = null;
            throw throwable;
        }
    }
}

