/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.output;

import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.components.modules.output.AbstractOutputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public class SessionAttributeOutputModule
extends AbstractOutputModule
implements OutputModule {
    public void setAttribute(Configuration modeConf, Map objectModel, String name, Object value) {
        String prefix = (String)this.settings.get("key-prefix", "org.apache.cocoon.components.modules.output.OutputModule");
        Request req = ObjectModelHelper.getRequest(objectModel);
        Session ses = req.getSession();
        if (ses == null || !req.isRequestedSessionIdValid()) {
            ses = req.getSession(true);
        }
        if (prefix != "") {
            ses.setAttribute(prefix + ":" + name, value);
        } else {
            ses.setAttribute(name, value);
        }
    }

    public void rollback(Configuration modeConf, Map objectModel, Exception e) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        Enumeration attributes = request.getSession().getAttributeNames();
        String prefix = (String)this.settings.get("key-prefix", "org.apache.cocoon.components.modules.output.OutputModule");
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            if (!name.startsWith(prefix)) continue;
            request.getSession().removeAttribute(name);
        }
        if (prefix != "") {
            request.getSession().setAttribute(prefix + ":", e.getMessage());
        } else {
            request.getSession().setAttribute("errorMessage", e.getMessage());
        }
    }

    public void commit(Configuration modeConf, Map objectModel) {
    }
}

