/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;

public class SimpleMappingMetaModule
extends AbstractMetaModule {
    String prefix = null;
    String suffix = null;
    Mapping mapping = null;

    public void configure(Configuration config2) throws ConfigurationException {
        this.inputConf = config2.getChild("input-module");
        this.prefix = config2.getChild("prefix").getValue(null);
        this.suffix = config2.getChild("suffix").getValue(null);
        this.mapping = new Mapping(config2);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        if (modeConf != null) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
        }
        String param = mapping.mapTo(name);
        if (prefix != null) {
            param = prefix + param;
        }
        if (suffix != null) {
            param = param + suffix;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("mapping ['" + name + "'] to ['" + param + "']");
        }
        return this.getValue(param, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        if (modeConf != null) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
        }
        String param = mapping.mapTo(name);
        if (prefix != null) {
            param = prefix + param;
        }
        if (suffix != null) {
            param = param + suffix;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("mapping ['" + name + "'] to ['" + param + "']");
        }
        return this.getValues(param, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        if (modeConf != null) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
        }
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        HashSet<String> set = new HashSet<String>();
        while (names.hasNext()) {
            String param = (String)names.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("reverse mapping starts with ['" + param + "']");
            }
            if (prefix != null) {
                if (!param.startsWith(prefix)) continue;
                param = param.substring(prefix.length());
            }
            if (suffix != null) {
                if (!param.endsWith(suffix)) continue;
                param = param.substring(0, param.length() - suffix.length());
            }
            if (param.length() < 1) continue;
            String newName = mapping.mapFrom(param);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("reverse mapping results in ['" + newName + "']");
            }
            set.add(newName);
        }
        return set.iterator();
    }

    protected class Mapping {
        Map toMap = null;
        Map fromMap = null;

        public Mapping() {
        }

        public Mapping(Map to, Map from) {
            this.toMap = to;
            this.fromMap = from;
        }

        public Mapping(Configuration config2) throws ConfigurationException {
            Configuration[] mappings = config2.getChildren("mapping");
            if (mappings != null) {
                if (this.toMap == null) {
                    this.toMap = new HashMap();
                }
                if (this.fromMap == null) {
                    this.fromMap = new HashMap();
                }
                int i = 0;
                while (i < mappings.length) {
                    String in = mappings[i].getAttribute("in", null);
                    String out = mappings[i].getAttribute("out", null);
                    if (in != null && out != null) {
                        this.toMap.put(in, out);
                        this.fromMap.put(out, in);
                    }
                    ++i;
                }
            }
        }

        private String mapIt(Map map, String param) {
            String newParam = param;
            if (map != null) {
                newParam = map.get(param);
                if (!map.containsKey(param) || newParam == null) {
                    newParam = param;
                }
            }
            return newParam;
        }

        public String mapFrom(String param) {
            return this.mapIt(this.fromMap, param);
        }

        public String mapTo(String param) {
            return this.mapIt(this.toMap, param);
        }
    }
}

