/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.InputModule;

public class ChainMetaModule
extends AbstractMetaModule {
    private ModuleHolder[] inputs = null;
    private boolean emptyAsNull = false;
    private boolean allNames = false;
    private boolean allValues = false;

    public void configure(Configuration config2) throws ConfigurationException {
        Configuration[] confs = config2.getChildren("input-module");
        if (confs.length > 0) {
            this.inputs = new ModuleHolder[confs.length];
            int j = 0;
            int i = 0;
            while (i < confs.length) {
                ModuleHolder module = new ModuleHolder();
                module.name = confs[i].getAttribute("name", null);
                if (module.name == null) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("No name attribute for module configuration. Skipping.");
                    }
                } else {
                    module.config = confs[i];
                    this.inputs[j] = module;
                    ++j;
                }
                ++i;
            }
        }
        this.emptyAsNull = config2.getChild("empty-as-null").getValueAsBoolean(this.emptyAsNull);
        this.allNames = config2.getChild("all-names").getValueAsBoolean(this.allNames);
        this.allValues = config2.getChild("all-values").getValueAsBoolean(this.allValues);
    }

    public void initialize() {
        block11: {
            try {
                Boolean bl = this.initialized;
                synchronized (bl) {
                    if (!this.initialized.booleanValue()) {
                        this.inputSelector = (ComponentSelector)this.manager.lookup(AbstractMetaModule.INPUT_MODULE_SELECTOR);
                    }
                    if (this.inputSelector != null && this.inputSelector instanceof ThreadSafe) {
                        int i = 0;
                        while (i < this.inputs.length) {
                            if (this.inputs[i].name != null) {
                                this.inputs[i].input = this.obtainModule(this.inputs[i].name);
                            }
                            ++i;
                        }
                    } else if (!(this.inputSelector instanceof ThreadSafe)) {
                        this.manager.release((Component)this.inputSelector);
                        this.inputSelector = null;
                    }
                    this.initialized = new Boolean(true);
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block11;
                this.getLogger().warn("A problem occurred setting up input modules :'" + e.getMessage());
            }
        }
    }

    public void dispose() {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! dispose() FAILING");
            } else if (this.inputSelector != null) {
                int i = 0;
                while (i < this.inputs.length) {
                    if (this.inputs[i].input != null) {
                        this.inputSelector.release((Component)this.inputs[i].input);
                    }
                    ++i;
                }
                this.manager.release((Component)this.inputSelector);
            }
        }
    }

    public Object[] getAttributeValues(String attr, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! getAttributeValues() FAILING");
            }
            return null;
        }
        Configuration[] inputConfigs = null;
        boolean allValues = this.allValues;
        boolean emptyAsNull = this.emptyAsNull;
        if (modeConf != null) {
            inputConfigs = modeConf.getChildren("input-modules");
            emptyAsNull = modeConf.getChild("empty-as-null").getValueAsBoolean(emptyAsNull);
            allValues = modeConf.getChild("all-values").getValueAsBoolean(allValues);
        }
        Object[] value = null;
        boolean debug = this.getLogger().isDebugEnabled();
        ArrayList<Object> values = null;
        if (allValues) {
            values = new ArrayList<Object>();
        }
        if (inputConfigs == null) {
            int i = 0;
            while (i < this.inputs.length && (value == null || allValues)) {
                if (this.inputs[i].name != null) {
                    value = this.getValues(attr, objectModel, this.inputs[i].input, this.inputs[i].name, this.inputs[i].config);
                    if (emptyAsNull && value != null && value.length == 0) {
                        value = null;
                    }
                    if (emptyAsNull && value != null && value.length == 1 && value[0] instanceof String && ((String)value[0]).equals("")) {
                        value = null;
                    }
                    if (debug) {
                        this.getLogger().debug("read from " + this.inputs[i].name + " attribute " + attr + " as " + value);
                    }
                    if (allValues && value != null) {
                        values.addAll(Arrays.asList(value));
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < inputConfigs.length && (value == null || allValues)) {
                String name = inputConfigs[i].getAttribute("name", null);
                if (name != null) {
                    value = this.getValues(attr, objectModel, null, name, inputConfigs[i]);
                    if (emptyAsNull && value != null && value.length == 0) {
                        value = null;
                    }
                    if (emptyAsNull && value != null && value.length == 1 && value[0] instanceof String && ((String)value[0]).equals("")) {
                        value = null;
                    }
                    if (debug) {
                        this.getLogger().debug("read from " + name + " attribute " + attr + " as " + value);
                    }
                    if (allValues && value != null) {
                        values.addAll(Arrays.asList(value));
                    }
                }
                ++i;
            }
        }
        return allValues ? values.toArray() : value;
    }

    private void addIterator(Collection col, Iterator iter) {
        while (iter != null && iter.hasNext()) {
            col.add(iter.next());
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! getAttributeNames() FAILING");
            }
            return null;
        }
        Configuration[] inputConfigs = null;
        boolean emptyAsNull = this.emptyAsNull;
        boolean allNames = this.allNames;
        if (modeConf != null) {
            inputConfigs = modeConf.getChildren("input-modules");
            emptyAsNull = modeConf.getChild("empty-as-null").getValueAsBoolean(emptyAsNull);
            allNames = modeConf.getChild("all-names").getValueAsBoolean(allNames);
        }
        Iterator value = null;
        ArrayList values = null;
        if (allNames) {
            values = new ArrayList();
        }
        boolean debug = this.getLogger().isDebugEnabled();
        if (inputConfigs == null) {
            int i = 0;
            while (i < this.inputs.length && (value == null || allNames)) {
                if (this.inputs[i].name != null) {
                    value = this.getNames(objectModel, this.inputs[i].input, this.inputs[i].name, this.inputs[i].config);
                    if (debug) {
                        this.getLogger().debug("read from " + this.inputs[i].name + " AttributeNames as " + value);
                    }
                    if (allNames && value != null) {
                        this.addIterator(values, value);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < inputConfigs.length && value == null) {
                String name = inputConfigs[i].getAttribute("name", null);
                if (name != null) {
                    value = this.getNames(objectModel, null, name, inputConfigs[i]);
                    if (debug) {
                        this.getLogger().debug("read from " + name + " AttributeNames as " + value);
                    }
                    if (allNames && value != null) {
                        this.addIterator(values, value);
                    }
                }
                ++i;
            }
        }
        return allNames ? values.iterator() : value;
    }

    public Object getAttribute(String attr, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] values = this.getAttributeValues(attr, modeConf, objectModel);
        return values != null ? values[0] : null;
    }

    class ModuleHolder {
        public String name = null;
        public InputModule input = null;
        public Configuration config = null;

        ModuleHolder() {
        }
    }
}

