/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.markup.xsp.XSLTExtension;
import org.apache.cocoon.components.language.programming.CompiledProgrammingLanguage;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.java.AbstractJavaCompiler;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.JavaArchiveFilter;

public class JavaLanguage
extends CompiledProgrammingLanguage
implements Initializable,
ThreadSafe,
Composable,
Disposable {
    private ClassLoaderManager classLoaderManager;
    protected ComponentManager manager = null;
    private String classpath;

    public String getSourceExtension() {
        return "java";
    }

    public String getObjectExtension() {
        return "class";
    }

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        String classLoaderClass = params.getParameter("class-loader", "org.apache.cocoon.components.classloader.ClassLoaderManagerImpl");
        if (classLoaderClass != null) {
            try {
                this.classLoaderManager = (ClassLoaderManager)ClassUtils.newInstance(classLoaderClass);
            }
            catch (Exception e) {
                throw new ParameterException("Unable to load class loader: " + classLoaderClass, (Throwable)e);
            }
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
        if (this.classLoaderManager == null) {
            try {
                this.getLogger().debug("Looking up org.apache.cocoon.components.classloader.ClassLoaderManager");
                this.classLoaderManager = (ClassLoaderManager)manager.lookup("org.apache.cocoon.components.classloader.ClassLoaderManager");
            }
            catch (Exception e) {
                this.getLogger().error("Could not find component", (Throwable)e);
            }
        }
    }

    public void initialize() throws Exception {
        String systemBootClasspath = System.getProperty("sun.boot.class.path");
        String systemClasspath = System.getProperty("java.class.path");
        String systemExtDirs = System.getProperty("java.ext.dirs");
        String systemExtClasspath = null;
        try {
            systemExtClasspath = this.expandDirs(systemExtDirs);
        }
        catch (Exception e) {
            this.getLogger().warn("Could not expand Directory:" + systemExtDirs, (Throwable)e);
        }
        this.classpath = (((CompiledProgrammingLanguage)this).classpath != null ? File.pathSeparator + ((CompiledProgrammingLanguage)this).classpath : "") + (systemBootClasspath != null ? File.pathSeparator + systemBootClasspath : "") + (systemClasspath != null ? File.pathSeparator + systemClasspath : "") + (systemExtClasspath != null ? File.pathSeparator + systemExtClasspath : "");
    }

    protected Class loadProgram(String name, File baseDirectory) throws LanguageException {
        try {
            this.classLoaderManager.addDirectory(baseDirectory);
            return this.classLoaderManager.loadClass(name.replace(File.separatorChar, '.'));
        }
        catch (Exception e) {
            throw new LanguageException("Could not load class for program '" + name + "' due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    protected void compile(String name, File baseDirectory, String encoding) throws LanguageException {
        try {
            AbstractJavaCompiler compiler = (AbstractJavaCompiler)this.compilerClass.newInstance();
            compiler.setLogger(this.getLogger());
            int pos = name.lastIndexOf(File.separatorChar);
            String filename = name.substring(pos + 1);
            String pathname = baseDirectory.getCanonicalPath() + File.separator + name.substring(0, pos).replace(File.separatorChar, '/');
            String filename_abs = pathname + File.separator + filename + "." + this.getSourceExtension();
            compiler.setFile(filename_abs);
            compiler.setSource(pathname);
            compiler.setDestination(baseDirectory.getCanonicalPath());
            compiler.setClasspath(baseDirectory.getCanonicalPath() + this.classpath);
            if (encoding != null) {
                compiler.setEncoding(encoding);
            }
            this.getLogger().debug("Compiling " + filename_abs);
            if (!compiler.compile()) {
                StringBuffer message = new StringBuffer("Error compiling ");
                message.append(filename);
                message.append(":\n");
                List errors = compiler.getErrors();
                int count = errors.size();
                int i = 0;
                while (i < count) {
                    CompilerError error = (CompilerError)errors.get(i);
                    if (i > 0) {
                        message.append("\n");
                    }
                    message.append("Line ");
                    message.append(error.getStartLine());
                    message.append(", column ");
                    message.append(error.getStartColumn());
                    message.append(": ");
                    message.append(error.getMessage());
                    ++i;
                }
                throw new LanguageException(message.toString());
            }
        }
        catch (InstantiationException e) {
            this.getLogger().warn("Could not instantiate the compiler", (Throwable)e);
            throw new LanguageException("Could not instantiate the compiler: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.getLogger().warn("Could not access the compiler class", (Throwable)e);
            throw new LanguageException("Could not access the compiler class: " + e.getMessage());
        }
        catch (IOException e) {
            this.getLogger().warn("Error during compilation", (Throwable)e);
            throw new LanguageException("Error during compilation: " + e.getMessage());
        }
    }

    public void doUnload(Object program) throws LanguageException {
        this.classLoaderManager.reinstantiate();
    }

    public String quoteString(String constant) {
        return XSLTExtension.escapeString(constant);
    }

    private String expandDirs(String dirPaths) {
        StringTokenizer st = new StringTokenizer(dirPaths, File.pathSeparator);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            File dir = new File(d);
            if (!dir.isDirectory()) {
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("Attempted to retrieve directory listing of non-directory " + dir.toString());
                continue;
            }
            File[] files = dir.listFiles(new JavaArchiveFilter());
            int i = 0;
            while (i < files.length) {
                buffer.append(files[i]).append(File.pathSeparator);
                ++i;
            }
        }
        return buffer.toString();
    }

    public void dispose() {
        this.manager.release((Component)this.classLoaderManager);
    }
}

