/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.generator;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.generator.CompiledComponent;
import org.apache.cocoon.components.language.generator.GeneratorSelector;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.components.language.markup.MarkupLanguage;
import org.apache.cocoon.components.language.programming.CodeFormatter;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.IOUtils;
import org.xml.sax.InputSource;

public class ProgramGeneratorImpl
extends AbstractLoggable
implements ProgramGenerator,
Contextualizable,
Composable,
Parameterizable,
Disposable,
ThreadSafe {
    protected boolean autoReload = false;
    protected boolean preload = false;
    protected GeneratorSelector cache;
    protected ComponentManager manager;
    protected ComponentSelector markupSelector;
    protected ComponentSelector languageSelector;
    protected File workDir;
    protected ClassLoaderManager classManager;
    protected String rootPackage;
    protected String contextDir;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.workDir == null) {
            this.workDir = (File)context.get((Object)"work-directory");
        }
        if (this.contextDir == null) {
            Context ctx = (Context)context.get((Object)"environment-context");
            try {
                String rootPath = ctx.getRealPath("/");
                if (rootPath != null) {
                    this.contextDir = new File(rootPath).toURL().toExternalForm();
                } else {
                    String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                    this.contextDir = webInf.substring(0, webInf.length() - "WEB-INF".length());
                }
                this.getLogger().debug("Context directory is " + this.contextDir);
            }
            catch (MalformedURLException e) {
                this.getLogger().warn("Could not get context directory", (Throwable)e);
                this.contextDir = "";
            }
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        if (this.manager == null && manager != null) {
            this.manager = manager;
            this.cache = (GeneratorSelector)this.manager.lookup(GeneratorSelector.ROLE + "Selector");
            this.markupSelector = (ComponentSelector)this.manager.lookup("org.apache.cocoon.components.language.markup.MarkupLanguageSelector");
            this.languageSelector = (ComponentSelector)this.manager.lookup("org.apache.cocoon.components.language.programming.ProgrammingLanguageSelector");
            this.classManager = (ClassLoaderManager)this.manager.lookup("org.apache.cocoon.components.classloader.ClassLoaderManager");
        }
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.autoReload = params.getParameterAsBoolean("auto-reload", this.autoReload);
        this.rootPackage = params.getParameter("root-package", "org.apache.cocoon.www");
        this.preload = params.getParameterAsBoolean("preload", this.preload);
    }

    private String getNormalizedName(String systemId) {
        StringBuffer contextFilename = new StringBuffer(this.rootPackage.replace('.', File.separatorChar));
        contextFilename.append(File.separator);
        if (systemId.startsWith(this.contextDir)) {
            contextFilename.append(systemId.substring(this.contextDir.length()));
        } else {
            contextFilename.append(systemId);
        }
        return IOUtils.normalizedFilename(contextFilename.toString());
    }

    public CompiledComponent load(ComponentManager newManager, String fileName, String markupLanguageName, String programmingLanguageName, SourceResolver resolver) throws Exception {
        Source source = resolver.resolve(fileName);
        return this.load(newManager, source, markupLanguageName, programmingLanguageName, resolver);
    }

    public CompiledComponent load(ComponentManager newManager, Source source, String markupLanguageName, String programmingLanguageName, SourceResolver resolver) throws Exception {
        CompiledComponent compiledComponent;
        String id = source.getSystemId();
        ProgrammingLanguage programmingLanguage = null;
        MarkupLanguage markupLanguage = null;
        try {
            long lastModified;
            String normalizedName = this.getNormalizedName(id);
            Program program = null;
            CompiledComponent programInstance = null;
            try {
                programInstance = (CompiledComponent)this.cache.select(normalizedName);
            }
            catch (Exception e) {
                this.getLogger().debug("The instance was not accessible from the internal cache. Proceeding.");
            }
            if (programInstance == null && this.preload) {
                try {
                    markupLanguage = (MarkupLanguage)this.markupSelector.select((Object)markupLanguageName);
                    programmingLanguage = (ProgrammingLanguage)this.languageSelector.select((Object)programmingLanguageName);
                    programmingLanguage.setLanguageName(programmingLanguageName);
                    program = programmingLanguage.preload(normalizedName, this.workDir, markupLanguage.getEncoding());
                    this.cache.addGenerator(newManager, normalizedName, program);
                    programInstance = (CompiledComponent)this.cache.select(normalizedName);
                }
                catch (Exception e) {
                    this.getLogger().debug("The program was not preloaded");
                }
            }
            if (programInstance != null && this.autoReload && programInstance.modifiedSince(lastModified = source.getLastModified())) {
                this.release(programInstance);
                programInstance = null;
                if (programmingLanguage == null) {
                    programmingLanguage = (ProgrammingLanguage)this.languageSelector.select((Object)programmingLanguageName);
                    programmingLanguage.setLanguageName(programmingLanguageName);
                }
                programmingLanguage.unload(program, normalizedName, this.workDir);
                this.cache.removeGenerator(normalizedName);
                program = null;
            }
            if (programInstance == null) {
                if (programmingLanguage == null) {
                    programmingLanguage = (ProgrammingLanguage)this.languageSelector.select((Object)programmingLanguageName);
                    programmingLanguage.setLanguageName(programmingLanguageName);
                }
                if (markupLanguage == null) {
                    markupLanguage = (MarkupLanguage)this.markupSelector.select((Object)markupLanguageName);
                }
                programInstance = this.createResource(newManager, source, normalizedName, markupLanguage, programmingLanguage, resolver);
            }
            if (programInstance instanceof Recomposable) {
                ((Recomposable)programInstance).recompose(newManager);
            }
            compiledComponent = programInstance;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            source.recycle();
            this.markupSelector.release(markupLanguage);
            this.languageSelector.release(programmingLanguage);
            throw throwable;
        }
        source.recycle();
        this.markupSelector.release((Component)markupLanguage);
        this.languageSelector.release((Component)programmingLanguage);
        return compiledComponent;
    }

    private CompiledComponent createResource(ComponentManager newManager, Source source, String normalizedName, MarkupLanguage markupLanguage, ProgrammingLanguage programmingLanguage, SourceResolver resolver) throws Exception {
        CompiledComponent programInstance = null;
        ProgramGeneratorImpl programGeneratorImpl = this;
        synchronized (programGeneratorImpl) {
            try {
                CompiledComponent compiledComponent = (CompiledComponent)this.cache.select(normalizedName);
                return compiledComponent;
            }
            catch (Exception cme) {
                this.getLogger().debug("Creating resource " + normalizedName);
                try {
                    Program program = this.generateResource(source, normalizedName, markupLanguage, programmingLanguage, resolver);
                    this.cache.addGenerator(newManager, normalizedName, program);
                }
                catch (LanguageException le) {
                    this.getLogger().debug("Language Exception", (Throwable)((Object)le));
                    throw new ProcessingException("Language Exception", (Throwable)((Object)le));
                }
                try {
                    programInstance = (CompiledComponent)this.cache.select(normalizedName);
                }
                catch (Exception cme2) {
                    this.getLogger().debug("Can't load ServerPage", (Throwable)cme2);
                    throw new ProcessingException("Can't load ServerPage", cme2);
                }
            }
        }
        return programInstance;
    }

    private Program generateResource(Source source, String normalizedName, MarkupLanguage markupLanguage, ProgrammingLanguage programmingLanguage, SourceResolver resolver) throws Exception {
        File sourceFile;
        File sourceDir;
        InputSource is = source.getInputSource();
        String code = markupLanguage.generateCode(is, normalizedName, programmingLanguage, resolver);
        if (code == null || code.length() == 0) {
            throw new ProcessingException("Failed to generate program code (this may happen if you use Xalan in incremental processing mode). Please check log file and/or console for errors.");
        }
        String encoding = markupLanguage.getEncoding();
        CodeFormatter codeFormatter = programmingLanguage.getCodeFormatter();
        if (codeFormatter != null) {
            code = codeFormatter.format(code, encoding);
        }
        if ((sourceDir = (sourceFile = new File(this.workDir, normalizedName + "." + programmingLanguage.getSourceExtension())).getParentFile()) != null) {
            sourceDir.mkdirs();
        }
        IOUtils.serializeString(sourceFile, code);
        Program program = programmingLanguage.load(normalizedName, this.workDir, markupLanguage.getEncoding());
        return program;
    }

    public void release(CompiledComponent component) {
        this.cache.release(component);
    }

    public void remove(Source source) {
        String normalizedName = this.getNormalizedName(source.getSystemId());
        this.cache.removeGenerator(normalizedName);
    }

    public void dispose() {
        this.manager.release((Component)this.cache);
        this.cache = null;
        this.manager.release((Component)this.markupSelector);
        this.markupSelector = null;
        this.manager.release((Component)this.languageSelector);
        this.languageSelector = null;
        this.manager.release((Component)this.classManager);
        this.classManager = null;
        this.manager = null;
        this.workDir = null;
        this.contextDir = null;
    }
}

