/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

class Workbook {
    private HSSFWorkbook _workbook = new HSSFWorkbook();
    private int _sheet_index = 0;

    Workbook() {
    }

    String getNextName() {
        return "Sheet" + this._sheet_index++;
    }

    HSSFSheet createSheet(String name) {
        return this._workbook.createSheet(name);
    }

    int getPhysicalIndex(String name) {
        return this._workbook.getSheetIndex(name);
    }

    void renameSheet(int index, String name) {
        this._workbook.setSheetName(index, name);
    }

    HSSFCellStyle createStyle() {
        HSSFCellStyle style = this._workbook.createCellStyle();
        return style;
    }

    HSSFFont createFont() {
        HSSFFont font = this._workbook.createFont();
        return font;
    }

    HSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    void write(POIFSFileSystem filesystem) throws IOException {
        filesystem.createDocument((InputStream)new ByteArrayInputStream(this._workbook.getBytes()), "Workbook");
    }
}

