/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractValidatorAction;
import org.apache.cocoon.acting.ValidatorActionHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.Tokenizer;

public class SessionValidatorAction
extends AbstractValidatorAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Request req = ObjectModelHelper.getRequest(objectModel);
        if (req == null) {
            this.getLogger().debug("No request object");
            return null;
        }
        Session session = req.getSession(false);
        if (session == null) {
            this.getLogger().debug("No session object");
            return null;
        }
        boolean reloadable = true;
        if (this.settings.containsKey("reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get("reloadable"));
        }
        try {
            Configuration conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get("descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", reloadable));
            String valsetstr = parameters.getParameter("validate-set", (String)this.settings.get("validate-set"));
            String valstr = parameters.getParameter("validate", (String)this.settings.get("validate"));
            Configuration[] desc = conf.getChildren("parameter");
            Configuration[] csets = conf.getChildren("constraint-set");
            HashMap<String, Object> actionMap = new HashMap<String, Object>();
            if (valstr != null && !"".equals(valstr.trim())) {
                this.getLogger().debug("Validating parameters as specified via 'validate' parameter");
                String[] rparams = Tokenizer.tokenize(valstr, ",", false);
                ValidatorActionHelper result = null;
                String name = null;
                HashMap<String, Object> params = new HashMap<String, Object>(rparams.length);
                int i = 0;
                while (i < rparams.length) {
                    name = rparams[i];
                    if (name == null || "".equals(name.trim())) {
                        this.getLogger().debug("Wrong syntax of the 'validate' parameter");
                        return null;
                    }
                    name = name.trim();
                    params.put(name, session.getAttribute(name));
                    ++i;
                }
                int i2 = 0;
                while (i2 < rparams.length) {
                    name = rparams[i2].trim();
                    result = this.validateParameter(name, null, desc, params, false);
                    if (!result.isOK()) {
                        this.getLogger().debug("Validation failed for parameter " + name);
                        return null;
                    }
                    session.setAttribute(name, result.getObject());
                    actionMap.put(name, result.getObject());
                    ++i2;
                }
            }
            if (valsetstr != null && !"".equals(valsetstr.trim())) {
                this.getLogger().debug("Validating parameters from given constraint-set " + valsetstr);
                Configuration cset = null;
                String setname = null;
                int j = 0;
                boolean found = false;
                j = 0;
                while (j < csets.length) {
                    setname = csets[j].getAttribute("name", "");
                    if (valsetstr.trim().equals(setname.trim())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.getLogger().debug("Given set " + valsetstr + " does not exist in a description file");
                    return null;
                }
                cset = csets[j];
                Configuration[] set = cset.getChildren("validate");
                ValidatorActionHelper result = null;
                String name = null;
                HashMap<String, Object> params = new HashMap<String, Object>(set.length);
                this.getLogger().debug("Given set " + valsetstr + " contains " + set.length + " rules");
                int i = 0;
                while (i < set.length) {
                    name = set[i].getAttribute("name", "");
                    if ("".equals(name.trim())) {
                        this.getLogger().debug("Wrong syntax  of 'validate' children nr. " + i);
                        return null;
                    }
                    name = name.trim();
                    params.put(name, session.getAttribute(name));
                    ++i;
                }
                int i3 = 0;
                while (i3 < set.length) {
                    name = set[i3].getAttribute("name", null);
                    result = this.validateParameter(name, set[i3], desc, params, false);
                    if (!result.isOK()) {
                        this.getLogger().debug("Validation failed for parameter " + name);
                        return null;
                    }
                    session.setAttribute(name, result.getObject());
                    actionMap.put(name, result.getObject());
                    ++i3;
                }
            }
            this.getLogger().debug("All session params validated");
            return Collections.unmodifiableMap(actionMap);
        }
        catch (Exception e) {
            this.getLogger().debug("exception: ", (Throwable)e);
            return null;
        }
    }
}

