/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Modifiable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.language.generator.CompiledComponent;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.source.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.source.SourceHandler;
import org.apache.cocoon.components.source.URLSource;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.SitemapManager;
import org.apache.cocoon.util.ClassUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class Cocoon
extends AbstractLoggable
implements ThreadSafe,
Component,
Initializable,
Disposable,
Modifiable,
Processor,
Contextualizable,
Composable,
LogKitManageable {
    private org.apache.avalon.framework.context.Context context;
    private ModifiableSource configurationFile;
    private Configuration configuration;
    private LogKitManager logKitManager;
    private String classpath;
    private File workDir;
    private ExcaliburComponentManager componentManager;
    private ComponentManager parentComponentManager;
    private boolean disposed = false;
    private volatile int activeRequestCount = 0;
    private Processor threadSafeProcessor = null;

    public Cocoon() throws ConfigurationException {
        this.setSystemProperties();
    }

    public void compose(ComponentManager manager) {
        this.parentComponentManager = manager;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.context == null) {
            this.context = context;
            this.classpath = (String)context.get((Object)"classpath");
            this.workDir = (File)context.get((Object)"work-directory");
            try {
                this.configurationFile = new DelayedRefreshSourceWrapper(new URLSource((URL)context.get((Object)"config-url"), (ComponentManager)this.componentManager), 1000L);
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not open configuration file.", (Throwable)ioe);
                throw new ContextException("Could not open configuration file.", (Throwable)ioe);
            }
            catch (Exception e) {
                this.getLogger().error("contextualize(..) Exception", (Throwable)e);
                throw new ContextException("contextualize(..) Exception", (Throwable)e);
            }
        }
    }

    public void setLogKitManager(LogKitManager logKitManager) {
        this.logKitManager = logKitManager;
    }

    public void initialize() throws Exception {
        this.componentManager = this.parentComponentManager != null ? new CocoonComponentManager(this.parentComponentManager, (ClassLoader)this.context.get((Object)"class-loader")) : new CocoonComponentManager((ClassLoader)this.context.get((Object)"class-loader"));
        this.componentManager.setLogger(this.getLogger().getChildLogger("manager"));
        this.componentManager.contextualize(this.context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New Cocoon object.");
        }
        this.dumpSystemProperties();
        String parser = System.getProperty("org.apache.cocoon.components.parser.Parser", "org.apache.avalon.excalibur.xml.JaxpParser");
        if (!"org.apache.avalon.excalibur.xml.JaxpParser".equals(parser)) {
            this.getLogger().warn("Deprecated property org.apache.cocoon.components.parser.Parser is used. Please use org.apache.avalon.excalibur.xml.Parser instead.");
            if ("org.apache.cocoon.components.parser.XercesParser".equals(parser)) {
                parser = "org.apache.avalon.excalibur.xml.XercesParser";
            } else {
                this.getLogger().warn("Unknown value for deprecated property: org.apache.cocoon.components.parser.Parser, value: " + parser + ". If you experience problems during startup, check the parser configuration section of the documentation.");
            }
        } else {
            parser = System.getProperty("org.apache.avalon.excalibur.xml.Parser", "org.apache.avalon.excalibur.xml.JaxpParser");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using parser: " + parser);
        }
        ExcaliburComponentManager startupManager = new ExcaliburComponentManager((ClassLoader)this.context.get((Object)"class-loader"));
        startupManager.setLogger(this.getLogger().getChildLogger("startup"));
        startupManager.contextualize(this.context);
        startupManager.setLogKitManager(this.logKitManager);
        try {
            startupManager.addComponent(Parser.ROLE, ClassUtils.loadClass(parser), (Configuration)new DefaultConfiguration("", "empty"));
        }
        catch (Exception e) {
            this.getLogger().error("Could not load parser, Cocoon object not created.", (Throwable)e);
            throw new ConfigurationException("Could not load parser " + parser, (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Classpath = " + this.classpath);
            this.getLogger().debug("Work directory = " + this.workDir.getCanonicalPath());
        }
        startupManager.initialize();
        this.configure(startupManager);
        startupManager.dispose();
        startupManager = null;
        this.componentManager.initialize();
        Processor processor = (Processor)this.componentManager.lookup("org.apache.cocoon.Processor");
        if (processor instanceof ThreadSafe) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is ThreadSafe");
            }
            this.threadSafeProcessor = processor;
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is NOT ThreadSafe -- will be looked up at each request");
            }
            this.componentManager.release((Component)processor);
        }
    }

    private void dumpSystemProperties() {
        try {
            Enumeration<?> e = System.getProperties().propertyNames();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("===== System Properties Start =====");
            }
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug(key + "=" + System.getProperty(key));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("===== System Properties End =====");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration configure(ExcaliburComponentManager startupManager) throws ConfigurationException, ContextException {
        DefaultRoleManager drm;
        Configuration roleConfig;
        Parser p;
        block21: {
            InputSource is;
            block20: {
                p = null;
                roleConfig = null;
                try {
                    try {
                        this.configurationFile.refresh();
                        p = (Parser)startupManager.lookup(Parser.ROLE);
                        SAXConfigurationHandler b = new SAXConfigurationHandler();
                        InputStream inputStream = ClassUtils.getResource("org/apache/cocoon/cocoon.roles").openStream();
                        is = new InputSource(inputStream);
                        is.setSystemId(this.configurationFile.getSystemId());
                        p.parse(is, (ContentHandler)b);
                        roleConfig = b.getConfiguration();
                    }
                    catch (Exception e) {
                        this.getLogger().error("Could not configure Cocoon environment", (Throwable)e);
                        throw new ConfigurationException("Error trying to load configurations", (Throwable)e);
                    }
                    Object var8_9 = null;
                    if (p == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (p != null) {
                        startupManager.release((Component)p);
                    }
                    throw throwable;
                }
                startupManager.release((Component)p);
            }
            drm = new DefaultRoleManager();
            drm.setLogger(this.getLogger().getChildLogger("roles"));
            drm.configure(roleConfig);
            roleConfig = null;
            try {
                try {
                    p = (Parser)startupManager.lookup(Parser.ROLE);
                    SAXConfigurationHandler b = new SAXConfigurationHandler();
                    is = this.configurationFile.getInputSource();
                    p.parse(is, (ContentHandler)b);
                    this.configuration = b.getConfiguration();
                }
                catch (Exception e) {
                    this.getLogger().error("Could not configure Cocoon environment", (Throwable)e);
                    throw new ConfigurationException("Error trying to load configurations", (Throwable)e);
                }
                Object var10_14 = null;
                if (p == null) break block21;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (p != null) {
                    startupManager.release((Component)p);
                }
                throw throwable;
            }
            startupManager.release((Component)p);
        }
        Configuration conf = this.configuration;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Root configuration: " + conf.getName());
        }
        if (!"cocoon".equals(conf.getName())) {
            throw new ConfigurationException("Invalid configuration file\n" + conf.toString());
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuration version: " + conf.getAttribute("version"));
        }
        if (!"2.0".equals(conf.getAttribute("version"))) {
            throw new ConfigurationException("Invalid configuration schema version. Must be '2.0'.");
        }
        String userRoles = conf.getAttribute("user-roles", "");
        if (!"".equals(userRoles)) {
            try {
                try {
                    p = (Parser)startupManager.lookup(Parser.ROLE);
                    SAXConfigurationHandler b = new SAXConfigurationHandler();
                    Context context = (Context)this.context.get((Object)"environment-context");
                    URL url = context.getResource(userRoles);
                    InputSource is = new InputSource(new BufferedInputStream(url.openStream()));
                    is.setSystemId(this.configurationFile.getSystemId());
                    p.parse(is, (ContentHandler)b);
                    roleConfig = b.getConfiguration();
                }
                catch (Exception e) {
                    this.getLogger().error("Could not configure Cocoon environment with user roles file", (Throwable)e);
                    throw new ConfigurationException("Error trying to load user-roles configuration", (Throwable)e);
                }
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                startupManager.release((Component)p);
                throw throwable;
            }
            startupManager.release((Component)p);
            DefaultRoleManager urm = new DefaultRoleManager((RoleManager)drm);
            urm.setLogger(this.getLogger().getChildLogger("roles").getChildLogger("user"));
            urm.configure(roleConfig);
            roleConfig = null;
            drm = urm;
        }
        this.componentManager.setRoleManager((RoleManager)drm);
        this.componentManager.setLogKitManager(this.logKitManager);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting up components...");
        }
        this.componentManager.configure(conf);
        return conf;
    }

    public boolean modifiedSince(long date) {
        return date < this.configurationFile.getLastModified();
    }

    protected void setSystemProperties() {
        Properties props = new Properties();
        props.put("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        Properties systemProps = System.getProperties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String prop = (String)propEnum.nextElement();
            if (systemProps.containsKey(prop)) continue;
            systemProps.put(prop, props.getProperty(prop));
        }
        if (systemProps.containsKey("javax.xml.parsers.DocumentBuilderFactory") && systemProps.getProperty("javax.xml.parsers.DocumentBuilderFactory").startsWith("weblogic")) {
            systemProps.put("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            systemProps.put("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        System.setProperties(systemProps);
    }

    public void dispose() {
        this.componentManager.release((Component)this.threadSafeProcessor);
        this.componentManager.dispose();
        if (this.configurationFile != null) {
            this.configurationFile.recycle();
        }
        this.disposed = true;
    }

    protected void debug(Environment environment, StreamPipeline pipeline, EventPipeline eventPipeline) {
        String lineSeparator = System.getProperty("line.separator");
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        StringBuffer msg = new StringBuffer();
        msg.append("DEBUGGING INFORMATION:").append(lineSeparator);
        if (pipeline != null && eventPipeline != null) {
            msg.append("INTERNAL ");
        }
        msg.append("REQUEST: ").append(request.getRequestURI()).append(lineSeparator).append(lineSeparator);
        msg.append("CONTEXT PATH: ").append(request.getContextPath()).append(lineSeparator);
        msg.append("SERVLET PATH: ").append(request.getServletPath()).append(lineSeparator);
        msg.append("PATH INFO: ").append(request.getPathInfo()).append(lineSeparator).append(lineSeparator);
        msg.append("REMOTE HOST: ").append(request.getRemoteHost()).append(lineSeparator);
        msg.append("REMOTE ADDRESS: ").append(request.getRemoteAddr()).append(lineSeparator);
        msg.append("REMOTE USER: ").append(request.getRemoteUser()).append(lineSeparator);
        msg.append("REQUEST SESSION ID: ").append(request.getRequestedSessionId()).append(lineSeparator);
        msg.append("REQUEST PREFERRED LOCALE: ").append(request.getLocale().toString()).append(lineSeparator);
        msg.append("SERVER HOST: ").append(request.getServerName()).append(lineSeparator);
        msg.append("SERVER PORT: ").append(request.getServerPort()).append(lineSeparator).append(lineSeparator);
        msg.append("METHOD: ").append(request.getMethod()).append(lineSeparator);
        msg.append("CONTENT LENGTH: ").append(request.getContentLength()).append(lineSeparator);
        msg.append("PROTOCOL: ").append(request.getProtocol()).append(lineSeparator);
        msg.append("SCHEME: ").append(request.getScheme()).append(lineSeparator);
        msg.append("AUTH TYPE: ").append(request.getAuthType()).append(lineSeparator).append(lineSeparator);
        msg.append("CURRENT ACTIVE REQUESTS: ").append(this.activeRequestCount).append(lineSeparator);
        Enumeration e = request.getParameterNames();
        msg.append("REQUEST PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            String[] params = request.getParameterValues(p);
            int i = 0;
            while (i < params.length) {
                msg.append("[" + params[i] + "]");
                if (i != params.length - 1) {
                    msg.append(", ");
                }
                ++i;
            }
            msg.append("'").append(lineSeparator);
        }
        Enumeration e2 = request.getHeaderNames();
        msg.append("HEADER PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e2.hasMoreElements()) {
            String p = (String)e2.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            Enumeration e3 = request.getHeaders(p);
            while (e3.hasMoreElements()) {
                msg.append("[" + e3.nextElement() + "]");
                if (!e3.hasMoreElements()) continue;
                msg.append(", ");
            }
            msg.append("'").append(lineSeparator);
        }
        msg.append(lineSeparator).append("SESSION ATTRIBUTES:").append(lineSeparator).append(lineSeparator);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                e = session.getAttributeNames();
                while (e.hasMoreElements()) {
                    String p = (String)e.nextElement();
                    msg.append("PARAM: '").append(p).append("' ").append("VALUE: '").append(session.getAttribute(p)).append("'").append(lineSeparator);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(msg.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(Environment environment) throws Exception {
        boolean bl;
        Object key;
        block8: {
            boolean bl2;
            block7: {
                if (this.disposed) {
                    throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
                }
                key = CocoonComponentManager.startProcessing(environment);
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        ++this.activeRequestCount;
                        this.debug(environment, null, null);
                    }
                    if (this.threadSafeProcessor != null) {
                        bl2 = this.threadSafeProcessor.process(environment);
                        Object var8_5 = null;
                        break block7;
                    }
                    Processor processor = (Processor)this.componentManager.lookup("org.apache.cocoon.Processor");
                    try {
                        bl = processor.process(environment);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        this.componentManager.release((Component)processor);
                        throw throwable;
                    }
                    this.componentManager.release((Component)processor);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    CocoonComponentManager.endProcessing(environment, key);
                    if (!this.getLogger().isDebugEnabled()) throw throwable;
                    --this.activeRequestCount;
                    throw throwable;
                }
            }
            CocoonComponentManager.endProcessing(environment, key);
            if (!this.getLogger().isDebugEnabled()) return bl2;
            --this.activeRequestCount;
            return bl2;
        }
        Object var8_6 = null;
        CocoonComponentManager.endProcessing(environment, key);
        if (!this.getLogger().isDebugEnabled()) return bl;
        --this.activeRequestCount;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(Environment environment, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        boolean bl;
        block8: {
            boolean bl2;
            block7: {
                if (this.disposed) {
                    throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
                }
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        ++this.activeRequestCount;
                        this.debug(environment, pipeline, eventPipeline);
                    }
                    if (this.threadSafeProcessor != null) {
                        bl2 = this.threadSafeProcessor.process(environment, pipeline, eventPipeline);
                        Object var9_6 = null;
                        break block7;
                    }
                    Processor processor = (Processor)this.componentManager.lookup("org.apache.cocoon.Processor");
                    try {
                        bl = processor.process(environment);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        this.componentManager.release((Component)processor);
                        throw throwable;
                    }
                    this.componentManager.release((Component)processor);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (!this.getLogger().isDebugEnabled()) throw throwable;
                    --this.activeRequestCount;
                    throw throwable;
                }
            }
            if (!this.getLogger().isDebugEnabled()) return bl2;
            --this.activeRequestCount;
            return bl2;
        }
        Object var9_7 = null;
        if (!this.getLogger().isDebugEnabled()) return bl;
        --this.activeRequestCount;
        return bl;
    }

    public void generateSitemap(Environment environment) throws Exception {
        Component processor = this.componentManager.lookup("org.apache.cocoon.Processor");
        try {
            if (processor instanceof SitemapManager) {
                ((SitemapManager)processor).generateSitemap(environment);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.componentManager.release(processor);
            throw throwable;
        }
        this.componentManager.release(processor);
    }

    public void precompile(String fileName, Environment environment, String markupLanguage, String programmingLanguage) throws Exception {
        ProgramGenerator programGenerator = null;
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        SourceHandler sourceHandler = null;
        try {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("XSP generation begin:" + fileName);
                }
                programGenerator = (ProgramGenerator)this.componentManager.lookup("org.apache.cocoon.components.language.generator.ProgramGenerator");
                sourceHandler = (SourceHandler)this.componentManager.lookup("org.apache.cocoon.components.source.SourceHandler");
                environment.setSourceHandler(sourceHandler);
                CompiledComponent xsp = programGenerator.load((ComponentManager)this.componentManager, environment.resolve(fileName), markupLanguage, programmingLanguage, (SourceResolver)environment);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("XSP generation complete:" + xsp);
                }
                this.componentManager.release((Component)programGenerator);
            }
            catch (Exception e) {
                this.getLogger().error("Main: Error compiling XSP", (Throwable)e);
                throw e;
            }
            Object var10_10 = null;
            environment.setSourceHandler(oldSourceHandler);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            environment.setSourceHandler(oldSourceHandler);
            this.componentManager.release((Component)programGenerator);
            this.componentManager.release(sourceHandler);
            throw throwable;
        }
        this.componentManager.release((Component)programGenerator);
        this.componentManager.release((Component)sourceHandler);
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }
}

