/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttributeIterator
implements NodeIterator {
    private NodePointer parent;
    private QName name;
    private List attributes;
    private int position = 0;

    public DOMAttributeIterator(NodePointer parent, QName name) {
        this.parent = parent;
        this.name = name;
        this.attributes = new ArrayList();
        Node node = (Node)parent.getNodeValue();
        if (node.getNodeType() == 1) {
            String lname = name.getName();
            if (!lname.equals("*")) {
                Attr attr = this.getAttribute((Element)node, name);
                if (attr != null) {
                    this.attributes.add(attr);
                }
            } else {
                NamedNodeMap map = node.getAttributes();
                int count = map.getLength();
                int i = 0;
                while (i < count) {
                    Attr attr = (Attr)map.item(i);
                    if (this.testAttr(attr, name)) {
                        this.attributes.add(attr);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean testAttr(Attr attr, QName testName) {
        String nodePrefix = DOMNodePointer.getPrefix(attr);
        String nodeLocalName = DOMNodePointer.getLocalName(attr);
        if (nodePrefix != null && nodePrefix.equals("xmlns")) {
            return false;
        }
        if (nodePrefix == null && nodeLocalName.equals("xmlns")) {
            return false;
        }
        String testLocalName = this.name.getName();
        if (testLocalName.equals("*") || testLocalName.equals(nodeLocalName)) {
            String testPrefix = testName.getPrefix();
            if (DOMAttributeIterator.equalStrings(testPrefix, nodePrefix)) {
                return true;
            }
            String testNS = null;
            if (testPrefix != null) {
                testNS = this.parent.getNamespaceURI(testPrefix);
            }
            String nodeNS = null;
            if (nodePrefix != null) {
                nodeNS = this.parent.getNamespaceURI(nodePrefix);
            }
            return DOMAttributeIterator.equalStrings(testNS, nodeNS);
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    private Attr getAttribute(Element element, QName name) {
        String testPrefix = name.getPrefix();
        String testNS = null;
        if (testPrefix != null) {
            testNS = this.parent.getNamespaceURI(testPrefix);
        }
        if (testNS != null) {
            Attr attr = element.getAttributeNodeNS(testNS, name.getName());
            if (attr == null) {
                NamedNodeMap nnm = element.getAttributes();
                int i = 0;
                while (i < nnm.getLength()) {
                    attr = (Attr)nnm.item(i);
                    if (this.testAttr(attr, name)) {
                        return attr;
                    }
                    ++i;
                }
            }
            return attr;
        }
        return element.getAttributeNode(name.getName());
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new DOMAttributePointer(this.parent, (Attr)this.attributes.get(index));
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

