/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullElementPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class NodePointer
implements Pointer,
Cloneable,
Comparable {
    public static int WHOLE_COLLECTION = Integer.MIN_VALUE;
    protected int index = WHOLE_COLLECTION;
    public static String UNKNOWN_NAMESPACE = "<<unknown namespace>>";
    protected NodePointer parent;
    protected Locale locale;

    public static NodePointer newNodePointer(QName name, Object bean, Locale locale) {
        if (bean == null) {
            return new NullPointer(name, locale);
        }
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i = 0;
        while (i < factories.length) {
            NodePointer pointer = factories[i].createNodePointer(name, bean, locale);
            if (pointer != null) {
                return pointer;
            }
            ++i;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    public static NodePointer newChildNodePointer(NodePointer parent, QName name, Object bean) {
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i = 0;
        while (i < factories.length) {
            NodePointer pointer = factories[i].createNodePointer(parent, name, bean);
            if (pointer != null) {
                return pointer;
            }
            ++i;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    protected NodePointer(NodePointer parent) {
        this.parent = parent;
    }

    protected NodePointer(NodePointer parent, Locale locale) {
        this.parent = parent;
        this.locale = locale;
    }

    public NodePointer getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        Object value = this.getNodeValue();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public boolean isNode() {
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public int getLength() {
        Object value = this.getBaseValue();
        if (value == null) {
            return 1;
        }
        return ValueUtils.getLength(value);
    }

    public Object getValue() {
        return this.getNodeValue();
    }

    public NodePointer getValuePointer() {
        return this;
    }

    public boolean isActual() {
        if (this.index == WHOLE_COLLECTION) {
            return true;
        }
        return this.index >= 0 && this.index < this.getLength();
    }

    public abstract QName getName();

    public abstract Object getBaseValue();

    public abstract Object getNodeValue();

    public abstract void setValue(Object var1);

    public abstract int compareChildNodePointers(NodePointer var1, NodePointer var2);

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String nodeNS;
            String testNS;
            String nodePrefix;
            if (!this.isNode()) {
                return false;
            }
            QName testName = ((NodeNameTest)test).getNodeName();
            QName nodeName = this.getName();
            String testPrefix = testName.getPrefix();
            if (!NodePointer.equalStrings(testPrefix, nodePrefix = nodeName.getPrefix()) && !NodePointer.equalStrings(testNS = this.getNamespaceURI(testPrefix), nodeNS = this.getNamespaceURI(nodePrefix))) {
                return false;
            }
            String testLocalName = testName.getName();
            if (testLocalName.equals("*")) {
                return true;
            }
            return testLocalName.equals(nodeName.getName());
        }
        if (test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1) {
            return this.isNode();
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        this.setValue(value);
        return this;
    }

    public void remove() {
    }

    public NodePointer createPath(JXPathContext context) {
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + ", operation is not allowed for this type of node");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + ", operation is not allowed for this type of node");
    }

    public Locale getLocale() {
        if (this.locale == null && this.parent != null) {
            this.locale = this.parent.getLocale();
        }
        return this.locale;
    }

    public boolean isLanguage(String lang) {
        Locale loc = this.getLocale();
        String name = loc.toString().replace('_', '-');
        return name.toUpperCase().startsWith(lang.toUpperCase());
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != null && valuePointer != this) {
            return valuePointer.childIterator(test, reverse, startWith);
        }
        return null;
    }

    public NodeIterator attributeIterator(QName qname) {
        return null;
    }

    public NodeIterator namespaceIterator() {
        return null;
    }

    public NodePointer namespacePointer(String namespace) {
        return null;
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    protected boolean isDefaultNamespace(String prefix) {
        if (prefix == null) {
            return true;
        }
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            return false;
        }
        return namespace.equals(this.getDefaultNamespaceURI());
    }

    protected String getDefaultNamespaceURI() {
        return null;
    }

    public QName getExpandedName() {
        return this.getName();
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        return context.getPointerByID(id);
    }

    public Pointer getPointerByKey(JXPathContext context, String key, String value) {
        return context.getPointerByKey(key, value);
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getParent() != null) {
            QName name;
            buffer.append(this.getParent().asPath());
            if ((this.getParent().isNode() || this.parent instanceof NullElementPointer) && (name = this.getName()) != null) {
                buffer.append('/');
                buffer.append(name);
            }
        } else {
            QName name = this.getName();
            buffer.append(name);
        }
        if (this.index != WHOLE_COLLECTION && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.asPath();
    }

    public int compareTo(Object object) {
        NodePointer pointer = (NodePointer)object;
        if (this.parent == pointer.parent) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.compareChildNodePointers(this, pointer);
        }
        int depth1 = 0;
        NodePointer p1 = this;
        while (p1 != null) {
            ++depth1;
            p1 = p1.parent;
        }
        int depth2 = 0;
        NodePointer p2 = pointer;
        while (p2 != null) {
            ++depth2;
            p2 = p2.parent;
        }
        return this.compareNodePointers(this, depth1, pointer, depth2);
    }

    private int compareNodePointers(NodePointer p1, int depth1, NodePointer p2, int depth2) {
        if (depth1 < depth2) {
            int r = this.compareNodePointers(p1, depth1, p2.parent, depth2 - 1);
            if (r != 0) {
                return r;
            }
            return -1;
        }
        if (depth1 > depth2) {
            int r = this.compareNodePointers(p1.parent, depth1 - 1, p2, depth2);
            if (r != 0) {
                return r;
            }
            return 1;
        }
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 != null && p1.equals(p2)) {
            return 0;
        }
        if (depth1 == 1) {
            throw new JXPathException("Cannot compare pointers that do not belong to the same tree: '" + p1 + "' and '" + p2 + "'");
        }
        int r = this.compareNodePointers(p1.parent, depth1 - 1, p2.parent, depth2 - 1);
        if (r != 0) {
            return r;
        }
        return p1.parent.compareChildNodePointers(p1, p2);
    }

    public void printPointerChain() {
        NodePointer p = this;
        while (p != null) {
            System.err.println((p == this ? "POINTER: " : " PARENT: ") + p.getClass() + " " + p.asPath());
            if (!(p instanceof NodePointer)) continue;
            p = p.getParent();
        }
    }
}

