/*
 * Decompiled with CFR 0.152.
 */
package com.megginson.sax.rdf;

import com.megginson.sax.rdf.RDFException;
import com.megginson.sax.rdf.RDFHandler;
import java.io.IOException;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class RDFFilter
extends XMLFilterImpl {
    private static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final String RDF_STATEMENT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement".intern();
    private static final String RDF_BAG = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".intern();
    private static final String RDF_LI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#li".intern();
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".intern();
    private static final String RDF_SUBJECT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject".intern();
    private static final String RDF_PREDICATE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate".intern();
    private static final String RDF_OBJECT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#object".intern();
    private static final String DAMLNSURIPROP = "http://megginson.com/sax/rdf/damlns";
    private static final String DAML_DEFAULT = "http://www.daml.org/2001/03/daml+oil#";
    private static final String DAML = System.getProperty("http://megginson.com/sax/rdf/damlns", "http://www.daml.org/2001/03/daml+oil#").intern();
    private static final String DAML_LIST = (DAML + "List").intern();
    private static final String DAML_FIRST = (DAML + "first").intern();
    private static final String DAML_REST = (DAML + "rest").intern();
    private static final String DAML_NIL = (DAML + "nil").intern();
    private static final int TOP_LEVEL = 1;
    private static final int IN_RDF = 2;
    private static final int IN_DESCRIPTION = 3;
    private static final int IN_PROPERTY = 4;
    private static final int IN_RESOURCE_PROPERTY = 5;
    private static final int IN_EMPTY_RESOURCE_PROPERTY = 6;
    private static final int IN_LITERAL = 7;
    private static final int IN_XMLLITERAL = 8;
    private static final int IN_COMPOSITE_PROPERTY = 9;
    private static final int IN_XML = 10;
    private static final int IN_UNKNOWN = 11;
    private static final int START_DAML_COLLECTION = 12;
    private static final int IN_DAML_COLLECTION = 14;
    private static final int IN_DAML_COLLECTION_ELEMENT = 15;
    private int genCounter;
    private State currentState;
    private Locator locator;
    private boolean rdfProcessing;
    private RDFHandler rdfHandler;
    private Hashtable idTable;
    private State[] states;
    int statePos;
    int stateMax;

    public RDFFilter() {
        this.init(null);
    }

    public RDFFilter(XMLReader xMLReader) {
        this.init(xMLReader);
    }

    private void init(XMLReader xMLReader) {
        this.setParent(xMLReader);
        this.rdfHandler = null;
        this.rdfProcessing = true;
    }

    public boolean getFeature(String string) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (string.equals("http://megginson.com/sax/features/rdf")) {
            return this.rdfProcessing;
        }
        return super.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (string.equals("http://megginson.com/sax/features/rdf")) {
            this.rdfProcessing = bl;
        } else {
            super.setFeature(string, bl);
        }
    }

    public Object getProperty(String string) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (string.equals("http://megginson.com/sax/properties/rdf-handler")) {
            return this.rdfHandler;
        }
        return super.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (string.equals("http://megginson.com/sax/properties/rdf-handler")) {
            this.rdfHandler = (RDFHandler)object;
        } else {
            super.setProperty(string, object);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.getParent().setFeature("http://xml.org/sax/features/namespaces", true);
        this.getParent().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        this.genCounter = 0;
        this.stateMax = 16;
        this.statePos = 0;
        this.states = new State[this.stateMax];
        this.locator = null;
        this.idTable = new Hashtable();
        super.parse(inputSource);
        this.idTable = null;
        this.states = null;
        this.locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.rdfProcessing) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        this.pushState();
        String string4 = attributes.getValue(XMLNS, "lang");
        if (string4 != null) {
            this.currentState.lang = string4;
        }
        switch (this.currentState.state) {
            case 1: {
                if (RDFNS.equals(string)) {
                    if ("RDF".equals(string2)) {
                        this.currentState.state = 2;
                        break;
                    }
                    this.error("Unknown or out of context RDF element " + string2);
                    break;
                }
                this.currentState.state = 1;
                super.startElement(string, string2, string3, attributes);
                break;
            }
            case 2: {
                this.currentState.state = 3;
                this.startResource(string, string2, attributes);
                break;
            }
            case 3: 
            case 9: {
                this.currentState.state = 4;
                this.startProperty(string, string2, attributes);
                break;
            }
            case 4: {
                this.currentState.data.setLength(0);
                this.currentState.previousState.state = 5;
                this.currentState.state = 3;
                this.startResource(string, string2, attributes);
                break;
            }
            case 7: {
                this.error("No markup allowed in literal property");
                this.currentState.state = 11;
                break;
            }
            case 8: 
            case 10: {
                this.currentState.state = 10;
                super.startElement(string, string2, string3, attributes);
                break;
            }
            case 5: {
                this.error("Only one element allowed inside a property element");
                this.currentState.state = 11;
                break;
            }
            case 6: {
                this.error("No content allowed in property with rdf:resource, rdf:bagID, or property attributes");
                this.currentState.state = 11;
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.currentState.state = 15;
                this.currentState.previousState.state = 14;
                this.startResource(string, string2, attributes);
                break;
            }
            case 14: {
                this.currentState.state = 15;
                this.continueDAMLCollection();
                this.startResource(string, string2, attributes);
                break;
            }
            case 15: {
                this.currentState.state = 4;
                this.startProperty(string, string2, attributes);
                break;
            }
            default: {
                throw new RuntimeException("StartElement:Unexpected state " + this.currentState.state);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.rdfProcessing) {
            super.endElement(string, string2, string3);
            return;
        }
        switch (this.currentState.state) {
            case 1: 
            case 10: {
                super.endElement(string, string2, string3);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.endResource(string, string2);
                break;
            }
            case 4: 
            case 7: {
                this.endLiteralProperty(string, string2);
                break;
            }
            case 5: 
            case 6: {
                this.endResourceProperty(string, string2);
                break;
            }
            case 9: {
                this.endCompositeProperty(string, string2);
                break;
            }
            case 8: {
                this.endLiteralXMLProperty(string, string2);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.endDAMLCollection();
                break;
            }
            case 14: {
                this.endDAMLCollection();
                break;
            }
            case 15: {
                this.endDAMLCollectionElement();
                break;
            }
            default: {
                throw new RuntimeException("EndElement:Unexpected state");
            }
        }
        this.popState();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.rdfProcessing) {
            super.characters(cArray, n, n2);
            return;
        }
        switch (this.currentState.state) {
            case 1: 
            case 8: 
            case 10: {
                super.characters(cArray, n, n2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                if (this.isWhitespace(cArray, n, n2)) break;
                this.error("Out of context character data");
                this.currentState.state = 11;
                break;
            }
            case 4: {
                this.currentState.data.append(cArray, n, n2);
                if (this.isWhitespace(cArray, n, n2)) break;
                this.currentState.state = 7;
                break;
            }
            case 7: {
                this.currentState.data.append(cArray, n, n2);
                break;
            }
            case 6: {
                this.error("No content allowed in property with rdf:resource, rdf:bagID, or property attributes");
                this.currentState.state = 11;
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new RuntimeException("characters:Unexpected state");
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.rdfProcessing) {
            super.ignorableWhitespace(cArray, n, n2);
            return;
        }
        switch (this.currentState.state) {
            case 1: 
            case 8: 
            case 10: {
                super.ignorableWhitespace(cArray, n, n2);
                break;
            }
            default: {
                this.characters(cArray, n, n2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startResource(String string, String string2, Attributes attributes) throws SAXException {
        this.currentState.inContainer = false;
        this.currentState.hasPropertyAtts = false;
        if (RDFNS.equals(string)) {
            if (this.isRDFContainer(string2)) {
                this.currentState.inContainer = true;
            } else if (!this.isRDFResource(string2)) {
                this.error("Unknown or out of context RDF description element " + string2);
                this.currentState.state = 11;
                return;
            }
        }
        int n = 0;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            block24: {
                String string8;
                block25: {
                    String string9;
                    String string10;
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    string8 = attributes.getURI(n2);
                                    string10 = attributes.getLocalName(n2);
                                    string9 = attributes.getValue(n2);
                                    if (!RDFNS.equals(string8) && (!"".equals(string8) || !RDFNS.equals(string))) break block25;
                                    if (!"ID".equals(string10)) break block26;
                                    string3 = "#" + this.checkId(string9);
                                    ++n;
                                    break block24;
                                }
                                if (!"about".equals(string10)) break block27;
                                string4 = string9;
                                ++n;
                                break block24;
                            }
                            if (!"bagID".equals(string10)) break block28;
                            string7 = "#" + this.checkId(string9);
                            break block24;
                        }
                        if (!"aboutEach".equals(string10)) break block29;
                        string5 = string9;
                        ++n;
                        break block24;
                    }
                    if ("aboutEachPrefix".equals(string10)) {
                        string6 = string9;
                        ++n;
                        break block24;
                    } else if (this.isRDFProperty(string10) || this.currentState.inContainer && this.isItemAttribute(string10)) {
                        this.currentState.hasPropertyAtts = true;
                        break block24;
                    } else {
                        this.error("Unknown or out of context RDF attribute: " + string10);
                        this.currentState.state = 11;
                        return;
                    }
                }
                if (!XMLNS.equals(string8)) {
                    this.currentState.hasPropertyAtts = true;
                }
            }
            ++n2;
        }
        this.currentState.bagId = string7;
        if (string7 != null) {
            this.reportStatement(string7, RDF_TYPE, RDF_BAG, 1, false, null, null);
        }
        if (n == 0) {
            this.currentState.subject = this.genID();
            this.currentState.subjectType = 4;
        } else {
            if (n > 1) {
                this.error("Only one of about, ID, aboutEach, and aboutEachPrefix allowed");
                this.currentState.state = 11;
                return;
            }
            if (string3 != null) {
                this.currentState.subject = string3;
                this.currentState.subjectType = 1;
            } else if (string4 != null) {
                this.currentState.subject = string4;
                this.currentState.subjectType = 1;
            } else if (string5 != null) {
                this.currentState.subject = string5;
                this.currentState.subjectType = 3;
            } else if (string6 != null) {
                this.currentState.subject = string6;
                this.currentState.subjectType = 2;
            }
        }
        if (RDFNS.equals(string) && this.currentState.inContainer && (string4 != null || string5 != null || string6 != null || string7 != null)) {
            this.error("RDF containers do not allow about, aboutEach, aboutEachPrefix, or bagID");
        }
        if (!"Description".equals(string2)) {
            this.reportStatement(this.currentState.subject, RDF_TYPE, string + string2, this.currentState.subjectType, false, null, null);
        }
        this.currentState.previousState.object = this.currentState.subject;
        if (this.currentState.hasPropertyAtts) {
            this.reportPropAtts(string, attributes);
        }
    }

    private void endResource(String string, String string2) throws SAXException {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startProperty(String string, String string2, Attributes attributes) throws SAXException {
        String string3;
        String string4;
        if (!(!RDFNS.equals(string) || this.isRDFProperty(string2) || this.currentState.inContainer && "li".equals(string2))) {
            this.error("Unknown or out of context RDF property element " + string2);
            this.currentState.state = 11;
            return;
        }
        if (this.currentState.inContainer) {
            if (this.currentState.hasPropertyAtts) {
                this.error("RDF containers may not mix property attributes and property elements");
            }
            if (!RDFNS.equals(string) || !"li".equals(string2)) {
                this.error("RDF containers allow only rdf:li properties");
            }
        }
        this.currentState.predicate = (string + string2).intern();
        this.currentState.object = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.currentState.hasPropertyAtts = false;
        int n = 0;
        while (n < attributes.getLength()) {
            block28: {
                block29: {
                    String string9;
                    block31: {
                        block30: {
                            string4 = attributes.getURI(n);
                            string3 = attributes.getLocalName(n);
                            string9 = attributes.getValue(n);
                            if (!RDFNS.equals(string4) && (!"".equals(string4) || !RDFNS.equals(string))) break block29;
                            if (!"resource".equals(string3)) break block30;
                            string5 = string9;
                            break block28;
                        }
                        if (!"ID".equals(string3)) break block31;
                        string6 = "#" + this.checkId(string9);
                        break block28;
                    }
                    if ("bagID".equals(string3)) {
                        string7 = "#" + this.checkId(string9);
                        break block28;
                    } else if ("parseType".equals(string3)) {
                        string8 = "Resource".equals(string9) ? "Resource" : ("daml:collection".equals(string9) ? "daml:collection" : "Literal");
                        break block28;
                    } else {
                        if (!this.isRDFProperty(string3)) {
                            this.error("Unknown or out of context RDF attribute: " + string3);
                            this.currentState.state = 11;
                            return;
                        }
                        this.currentState.hasPropertyAtts = true;
                    }
                    break block28;
                }
                if (!XMLNS.equals(string4)) {
                    this.currentState.hasPropertyAtts = true;
                }
            }
            ++n;
        }
        if (this.currentState.inContainer) {
            if (string6 != null || string7 != null) {
                this.error("rdf:li does not allow an ID or bagID attribute");
            } else if (string8 != null && string5 != null) {
                this.error("rdf:li does not allow both parseType and resource");
            } else if (this.currentState.hasPropertyAtts) {
                this.error("rdf:li does not allow property attributes");
            }
            this.currentState.inContainer = false;
        }
        this.currentState.statementId = string6;
        if (string8 != null) {
            if (string5 != null) {
                this.error("rdf:resource not allowed with rdf:parseType");
                this.currentState.state = 11;
                return;
            }
            if (string7 != null) {
                this.error("rdf:bagID not allowed with rdf:parseType");
                this.currentState.state = 11;
                return;
            }
            if (this.currentState.hasPropertyAtts) {
                this.error("Property attributes not allowed with rdf:parseType");
                this.currentState.state = 11;
                return;
            }
            if (string8 == "Literal") {
                this.currentState.state = 8;
                if (this.rdfHandler == null) return;
                this.rdfHandler.startXMLStatement(this.currentState.subjectType, this.currentState.subject, this.currentState.predicate, this.currentState.lang);
                return;
            }
            if (string8 == "daml:collection") {
                string4 = this.genID();
                this.reportStatement(this.currentState.subject, this.currentState.predicate, string4, this.currentState.subjectType, false, null, null);
                this.reportStatement(string4, RDF_TYPE, DAML_LIST, 4, false, null, null);
                this.pushState();
                this.currentState.state = 12;
                this.currentState.bagId = null;
                this.currentState.subject = string4;
                this.currentState.subjectType = 4;
                return;
            }
            this.pushState();
            this.currentState.state = 9;
            this.currentState.bagId = null;
            this.currentState.subject = this.genID();
            this.currentState.subjectType = 4;
            return;
        }
        if (string5 == null && string7 == null) {
            if (!this.currentState.hasPropertyAtts) return;
        }
        int n2 = this.currentState.subjectType;
        if (string5 == null) {
            string5 = this.genID();
            this.currentState.subjectType = 4;
        } else {
            this.currentState.subjectType = 1;
        }
        if (string7 != null) {
            this.reportStatement(string7, RDF_TYPE, RDF_BAG, 1, false, null, null);
        }
        this.currentState.state = 6;
        string3 = this.currentState.subject;
        this.currentState.subject = string5;
        this.currentState.object = string5;
        this.currentState.bagId = string7;
        if (this.currentState.hasPropertyAtts) {
            this.reportPropAtts(string, attributes);
        }
        this.currentState.subject = string3;
        this.currentState.subjectType = n2;
    }

    private void endResourceProperty(String string, String string2) throws SAXException {
        this.reportStatement(this.currentState.subject, this.currentState.predicate, this.currentState.object, this.currentState.subjectType, false, this.currentState.bagId, this.currentState.statementId);
    }

    private void endCompositeProperty(String string, String string2) throws SAXException {
        this.reportStatement(this.currentState.previousState.subject, this.currentState.predicate, this.currentState.subject, this.currentState.previousState.subjectType, false, this.currentState.previousState.bagId, this.currentState.statementId);
        this.popState();
    }

    private void endLiteralProperty(String string, String string2) throws SAXException {
        if (RDFNS.equals(string) && this.isRDFResourceProperty(string2)) {
            this.warning("RDF property `" + string2 + "' expects a resource value, not a literal");
        }
        this.reportStatement(this.currentState.subject, this.currentState.predicate, this.currentState.data.toString(), this.currentState.subjectType, true, this.currentState.bagId, this.currentState.statementId);
        this.currentState.data.setLength(0);
    }

    private void endLiteralXMLProperty(String string, String string2) throws SAXException {
        if (RDFNS.equals(string) && this.isRDFResourceProperty(string2)) {
            this.warning("RDF property " + string2 + " expects a resource value, not a literal");
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endXMLStatement();
        }
    }

    private void startDAMLCollection() throws SAXException {
        String string = this.currentState.subject;
        int n = this.currentState.subjectType;
        this.pushState();
        this.currentState.subject = string;
        this.currentState.subjectType = n;
    }

    private void continueDAMLCollection() throws SAXException {
        String string = this.genID();
        this.reportStatement(this.currentState.previousState.subject, DAML_REST, string, this.currentState.previousState.subjectType, false, null, null);
        this.reportStatement(string, RDF_TYPE, DAML_LIST, 4, false, null, null);
        this.currentState.previousState.subject = string;
    }

    private void endDAMLCollectionElement() throws SAXException {
        this.reportStatement(this.currentState.previousState.subject, DAML_FIRST, this.currentState.subject, 4, false, null, null);
    }

    private void endDAMLCollection() throws SAXException {
        this.reportStatement(this.currentState.subject, DAML_REST, DAML_NIL, 4, false, null, null);
        this.popState();
    }

    private void reportPropAtts(String string, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getURI(n);
            String string3 = attributes.getLocalName(n);
            String string4 = attributes.getValue(n);
            if ("".equals(string2)) {
                string2 = string;
            }
            if (this.currentState.inContainer) {
                if (!RDFNS.equals(string2) || !this.isItemAttribute(string3)) {
                    this.error("Only rdf:_nnn property attributes allowed for containers");
                }
                this.reportStatement(this.currentState.subject, string2 + string3, string4, this.currentState.subjectType, true, this.currentState.bagId, null);
            } else if (RDFNS.equals(string2)) {
                if (this.isRDFProperty(string3)) {
                    boolean bl = true;
                    if (this.isRDFResourceProperty(string3)) {
                        if (string3.equals("type")) {
                            bl = false;
                        } else {
                            this.warning("RDF property `" + string3 + "' expects a resource value, not a literal");
                        }
                    }
                    this.reportStatement(this.currentState.subject, string2 + string3, string4, this.currentState.subjectType, bl, this.currentState.bagId, null);
                }
            } else if (!XMLNS.equals(string3)) {
                this.reportStatement(this.currentState.subject, string2 + string3, string4, this.currentState.subjectType, true, this.currentState.bagId, null);
            }
            ++n;
        }
    }

    private void reportStatement(String string, String string2, String string3, int n, boolean bl, String string4, String string5) throws SAXException {
        StringBuffer stringBuffer;
        int n2 = 1;
        if (RDF_LI.equals(string2)) {
            stringBuffer = new StringBuffer(RDFNS);
            stringBuffer.append('_');
            stringBuffer.append(this.currentState.enclosingDescription().liCounter++);
            string2 = stringBuffer.toString().intern();
        }
        if (this.rdfHandler != null) {
            if (bl) {
                this.rdfHandler.literalStatement(n, string, string2, string3, this.currentState.lang);
            } else {
                this.rdfHandler.resourceStatement(n, string, string2, string3);
            }
        }
        if (string5 == null && string4 != null) {
            string5 = this.genID();
            n2 = 4;
        }
        if (string4 != null) {
            stringBuffer = new StringBuffer(RDFNS);
            stringBuffer.append('_');
            stringBuffer.append(this.currentState.enclosingDescription().bagLiCounter++);
            this.reportStatement(string4, stringBuffer.toString(), string5, 1, false, null, null);
        }
        if (string5 != null) {
            this.reportStatement(string5, RDF_TYPE, RDF_STATEMENT, n2, false, null, null);
            this.reportStatement(string5, RDF_SUBJECT, string, n2, false, null, null);
            this.reportStatement(string5, RDF_PREDICATE, string2, n2, false, null, null);
            this.reportStatement(string5, RDF_OBJECT, string3, n2, bl, null, null);
        }
    }

    private void warning(String string) throws SAXException {
        ErrorHandler errorHandler = super.getErrorHandler();
        if (errorHandler != null) {
            if (this.locator != null) {
                errorHandler.warning(new RDFException(string, this.locator));
            } else {
                errorHandler.warning(new RDFException(string));
            }
        }
    }

    private void error(String string) throws SAXException {
        ErrorHandler errorHandler = super.getErrorHandler();
        if (errorHandler != null) {
            if (this.locator != null) {
                errorHandler.error(new RDFException(string, this.locator));
            } else {
                errorHandler.error(new RDFException(string));
            }
        }
    }

    private void pushState() {
        Object object;
        if (this.statePos >= this.stateMax) {
            object = new State[this.statePos * 2];
            System.arraycopy(this.states, 0, object, 0, this.statePos);
            this.states = object;
        }
        if ((object = this.states[this.statePos]) == null) {
            this.states[this.statePos] = new State();
            object = this.states[this.statePos];
        }
        if (this.currentState != null) {
            ((State)object).assign(this.currentState);
        }
        this.currentState = object;
        ++this.statePos;
    }

    private void popState() {
        --this.statePos;
        this.currentState = this.statePos > 0 ? this.states[this.statePos - 1] : null;
    }

    private String genID() {
        return "{__GEN" + this.genCounter++ + "}";
    }

    private boolean isItemAttribute(String string) {
        char[] cArray = string.toCharArray();
        if (cArray[0] != '_') {
            return false;
        }
        int n = 1;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean isWhitespace(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            switch (cArray[n3]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private boolean isRDFResource(String string) {
        return "Description".equals(string) || "Statement".equals(string) || "Property".equals(string) || this.isRDFContainer(string);
    }

    private boolean isRDFContainer(String string) {
        return "Seq".equals(string) || "Alt".equals(string) || "Bag".equals(string);
    }

    private boolean isRDFProperty(String string) {
        if (string.charAt(0) == '_') {
            int n = 1;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return this.isRDFResourceProperty(string) || "value".equals(string) || "object".equals(string);
    }

    private boolean isRDFResourceProperty(String string) {
        return "type".equals(string) || "subject".equals(string) || "predicate".equals(string);
    }

    private String checkId(String string) throws SAXException {
        if (this.idTable.containsKey(string)) {
            this.error("Duplicate RDF ID or bagID: " + string);
        } else {
            this.idTable.put(string, Boolean.TRUE);
        }
        return string;
    }

    class State {
        int state = 1;
        boolean inContainer = false;
        boolean hasPropertyAtts = false;
        String subject = null;
        String predicate = null;
        String object = null;
        StringBuffer data = new StringBuffer();
        String bagId = null;
        String statementId = null;
        int subjectType = -1;
        State previousState = null;
        int liCounter = 1;
        int bagLiCounter = 1;
        String lang = null;

        State() {
        }

        void assign(State state) {
            this.state = state.state;
            this.inContainer = state.inContainer;
            this.hasPropertyAtts = state.hasPropertyAtts;
            this.subject = state.subject;
            this.predicate = state.predicate;
            this.object = state.object;
            this.data = state.data;
            this.bagId = state.bagId;
            this.statementId = state.statementId;
            this.subjectType = state.subjectType;
            this.previousState = state;
            this.liCounter = 1;
            this.bagLiCounter = 1;
            this.lang = state.lang;
        }

        State enclosingDescription() {
            State state = this.previousState;
            while (state != null && state.state != 3) {
                state = state.previousState;
            }
            return state;
        }
    }
}

