/* RollCageX (sci-fi racer inspired by the original RollCage games)
 * Copyright (C) 2009-2010  Mats Wahlberg ("Slinger" on gorcx.net forum)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 


#ifndef _RCX_THREADS_H
#define _RCX_THREADS_H

#include <SDL/SDL_mutex.h>

//mutexes
extern SDL_mutex *ode_mutex;
extern SDL_mutex *sdl_mutex;
extern SDL_mutex *sync_mutex;
extern SDL_cond  *sync_cond;
//


//prototypes for communication/statistic variables
extern unsigned int stepsize_warnings;
extern Uint32 frame_count;
extern bool graphics_event_resize;
extern int graphics_event_resize_w, graphics_event_resize_h;

//functions
bool graphics_init(void);
void graphics_quit(void);
bool physics_init(void);
void physics_quit (void);

int graphics_loop (void);
int events_loop (void *d);
int physics_loop (void *d);



//TMP: used by events for keeping track of objects spawning
#include "object.hpp"
#include "car.hpp"
extern Object_Template *box; //keep track of our loaded debug box
extern Object_Template *sphere;
extern Object_Template *funbox;
extern Car *Venom;
extern Car *Reaper;

#endif
