/*
 * MicroEngine - A microkernel inspired game engine
 * Copyright (C) 2008 "Slinger" ("Sould Slinger" @ gorcx.net/forum),
 * _unless where otherwise stated_
 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */


#define load 0
#define unload 1
#define init 2
#define term 3

#define block_count 4
static const char block_name[block_count][7]={"load", "unload", "init", "term"};
static int active_block;

#define max_scripts 10

struct command {
	void (* func) (char *);
	char * args;
};

struct block {
	unsigned int start;
	unsigned int stop;
};

static struct {
	struct command *command;
	struct block *block;
} script[max_scripts]; //"database" with translated scripts

//variables functions needs to share
static int script_num;
static int command_num;
static char command [100];
static char argument [100];
static FILE * file;


