#!/bin/bash
#
# Copyright (C) 2006, 2007, 2008, 2009 Thomas Cort <tcort@tomcort.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

if [[ $# -ne 1 ]] ; then
	echo "Usage: $0 <ver>" 1>&2
	exit 1
fi
old_files=$(find . -name '.#*' -o -name '*.o' -o -name '*~' -o -name 'Makefile')
if [[ -n ${old_files} ]] ; then
	echo "Remove these temp files before making a package:"
	echo "${old_files}"
	exit 1
fi

ver="$1"
[[ "$ver" == "snap" ]] && ver=$(date -u +%Y%m%d)
bn="$(basename $(pwd))-${ver}"
[[ -d "../${bn}" ]] && rm -fr "../${bn}"
[[ -n "../${bn}.tar.bz2.sig" ]] && rm -fr "../${bn}.tar.bz2.sig"
mkdir "../${bn}" || exit 1
cp -r * "../${bn}/" || exit 1
find "../${bn}" -type d -name CVS -exec rm -rf '{}' \; 2>/dev/null
tar jcf "../${bn}".tar.bz2 "../${bn}" || exit 1
rm -fr "../${bn}" || exit 1
du -b "../${bn}".tar.bz2
gpg -b --use-agent "../${bn}".tar.bz2
bn="cpuinfo-data-$(date -u +%Y%m%d)"
[[ -d "../${bn}" ]] && rm -fr "../${bn}"
[[ -n "../${bn}.tar.bz2.sig" ]] && rm -fr "../${bn}.tar.bz2.sig"
mkdir "../${bn}" || exit 1
cp -r tests/data*/* "../${bn}/" || exit 1
find "../${bn}" -type d -name CVS -exec rm -rf '{}' \; 2>/dev/null
tar jcf "../${bn}".tar.bz2 "../${bn}" || exit 1
rm -fr "../${bn}" || exit 1
du -b "../${bn}".tar.bz2
gpg -b --use-agent "../${bn}".tar.bz2
