/*
 * examples/proccpuinfo.c - simple program to read /proc/cpuinfo and print out 
 *                          some information.
 *
 * Copyright (C) 2006, 2007, 2008, 2009 Thomas Cort <tcort@tomcort.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include "proccpuinfo.h"

int main() {
	proccpuinfo *info = proccpuinfo_read();

	if (!info)
		return 1;

	printf("architecture\t\t: %s\n",info->architecture);
	printf("hardware_platform\t: %s\n",info->hardware_platform);
	printf("frequency\t\t: %lf MHz\n", info->frequency);
	printf("cache\t\t\t: %d KB\n", info->cache);
	printf("cpus\t\t\t: %d processor%c\n",info->cpus, (info->cpus == 1 ? ' ' : 's'));
	printf("bogomips\t\t: %lf\n",info->bogomips);

	proccpuinfo_free(info);
	return 0;
}
