<?php
/*
 *Example of use of PrintIPP
 *
 * Copyright(C) 2005 Thomas Harding
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *
 */

error_reporting(E_ALL);

require_once("CupsPrintIPP.php");

echo "<h1>PHP PrintIPP example</h1>";

echo "Note that all options are not showed here<br />";

$ipp = new CupsPrintIPP(); // extended IPP with CUPS specific stuff
//$ipp = new PrintIPP(); // extended IPP with CUPS specific stuff
//$ipp = new ExtendedPrintIPP(); // extended IPP
//$ipp = new PrintIPP(); // Basic IPP (print job, print uri, get printer's attributes, cancel jobs)



$ipp->debug_level = 3; // Debugging very verbose
$ipp->setLog('/tmp/printipp','file',3); // logging verbose
$ipp->setHost("localhost");//Put your printer IP or hostname/fqdn here


//$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
$ipp->setPrinterURI("/printers/epson"); // Set printer URI here
//$ipp->setPrinterURI("/printers/foo"); // => abort "client-error-not-found"

$ipp->setUserName("php IPP tester");
$ipp->setFidelity(); // printing abort if every attribute could not be set on printer. NOTE: CUPS do not abort :)


//$ipp->setMimeMediaType('text/html');
//$ipp->setMimeMediaType('foo/bar'); // => client-error-document-format-not-supported
//$ipp->setMimeMediaType('application/postscript');
$ipp->setCharset('utf-8');
$ipp->setLanguage('fr_fr');

/* getting printer's attributes */
/*
$ipp->getPrinterAttributes();
echo "Printer's attributes :<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";

/* getting printers (CUPS extention) */

echo "Available printers [CUPS EXTENTION]:<pre>" ; 
echo $ipp->getPrinters() . "\n";
print_r($ipp->available_printers);
echo "</pre>";

for ($i = 0 ; $i < count($ipp->available_printers) ; $i ++) {
//$ipp->setPrinterURI($ipp->available_printers[$i]); // Set printer URI here
$ipp->getPrinterAttributes();
echo "Printer attributes for printer $i:<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";
if (isset($ipp->printer_attributes->printer_type->_value2)
        && ($ipp->printer_attributes->printer_type->_value2) == 'print-black')
    echo "The printer can print black<br />\n";
if (isset($ipp->printer_attributes->printer_type->_value3)
        && ($ipp->printer_attributes->printer_type->_value3) == 'print-color')
    echo "The printer can print color<br />\n";

    echo "Printer State: ".$ipp->printer_attributes->printer_state->_value0."<br />";
    echo "Printer State message: ".$ipp->printer_attributes->printer_state_message->_value0."<br />";
    echo "Document formats supported:<br /><pre>";

    $pointer = "_value0";
    for ($j = 0 ; isset($ipp->printer_attributes->document_format_supported->$pointer); $j++) {
        echo $ipp->printer_attributes->document_format_supported->$pointer . "\n";
        $pointer = "_value" . ($j + 1);
        }
    echo "</pre>";

echo "------- END FOR PRINTER $i -------------<br /n>";
}

/* printing a string */
/*
$ipp->setJobName("PHP Test: Text String",true); // default is false: number is automagically appended
$ipp->setRawText();
$ipp->setData("This is a text");//string to print.
echo "Job status ".$ipp->printJob()."<br />";
echo "Job Attributes:<pre>\n" ; print_r($ipp->job_attributes) ; echo "\n</pre>\n";
$ipp->unsetRawText();


/* printing a text file */
/*
        // HINT: you _must_ supply a charset or set output as raw text
        // note that mimeMediaType is resetted to octet-stream after each call of printJob (this is a feature).
//$ipp->setRawText();
$ipp->setCharset('us-ascii');
$ipp->setMimeMediaType('text/plain');

$ipp->setData("./testfiles/test.txt");//Path to file.
echo "Job status: ".$ipp->printJob("epson")."\n";


/* printing a document by URI */
/*
echo "Job Print URI status: ".$ipp->printUri("http://localhost/")."\n";

/* printing a text file in utf-8 */

$ipp->setUserName("foo bar");
$ipp->setDocumentName("testfile with UTF-8 characters");
$ipp->setCharset('utf-8');

// attributes without dedicated function
//$ipp->setMimeMediaType('text/plain'); // if autodetection do not work
//$ipp->setAttribute('orientation-requested','landscape');
//$ipp->setAttribute('number-up',2);
//$ipp->setAttribute('compression','gzip');
//$ipp->setData("./testfiles/test-utf8-compressed.txt.gz");//Path to file.
$ipp->setData("./testfiles/test-utf8.txt");//Path to file.
$success = $ipp->printJob();
//$ipp->setData("This is a test");
$ipp->setAttribute('media','A7');
$ipp->setData("./documentation/COPYING");
$ipp->setPageRanges('1:2 5:6');
$success = $ipp->printJob();

$ipp->setPageRanges('');
$ipp->setData("This is a test for strings");


$success = $ipp->printJob();
if (!$success) 
    echo "<br />Job status: OPERATION FAILED<br />";
else
    echo "Job status ".$success."<br />";


/* printing a postcript file */
/*
$ipp->setData("./testfiles/test.ps");
echo "Job status: ".$ipp->printJob("epson")."<br />";
*/

/* printing a png  file */
//$ipp->setData("./testfiles/test.png");
//echo "Job status: ".$ipp->printJob("epson")."<br />";

/* printing and cancelling job */
/*
echo "Printing and Cancelling a job<br />";
//$ipp->setData("./testfiles/test.ps");
//$ipp->setData("./testfiles/test-compressed.html.gz");
//$ipp->setData("./testfiles/test.html");
echo "Job status: ".$ipp->printJob("epson")."<br />";
$job = $ipp->last_job;
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setMessage(sprintf(_("job %s cancelled"),$job));
echo "Cancel status: ".$ipp->cancelJob($job)."<br />";
echo "</pre>";

/* printing strings, no form feed */
/*
$ipp->setRawText();
$ipp->unsetFormFeed();

$ipp->setData("This is a line\n");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is half a line ");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is a end of line\n");
echo "Job status: ".$ipp->printJob("epson")."<br />";

// set copies to 2 (same sheet of paper: form feed is unset)
$ipp->setData("This lines must appeared twice\r\n");
$ipp->setCopies(2);
echo "Job status: ".$ipp->printJob("epson")."<br />";
$ipp->setCopies(1);

// printing string, then form feed
$ipp->setFormFeed();
$ipp->setData("End of test");
echo "Job status: ".$ipp->printJob("epson");


/* send a buggy request */
/*
$ipp->setData("This is an error : nothing printed\n");
$ipp->generateError ("request_body_malformed");
echo "Job status: ".$ipp->printJob("epson");

$ipp->resetError("request_body_malformed");
*/

/* get informations about jobs and status */
echo "Available printers:<br />\n" ;
echo "<pre>\n";
print_r($ipp->available_printers);
echo "</pre>";

echo "Jobs:\n<br />" ; 
echo "<pre>\n";
print_r($ipp->jobs);
echo "</pre>";

echo "Jobs URIs:\n<br />\n";
echo "<pre>\n";
print_r($ipp->jobs_uri);
echo "</pre>";

echo "Printers URIs:\n" ; 
echo "<pre>\n";
print_r($ipp->printers_uri);
echo "</pre>";

echo "Operations status:\n" ; 
echo "<pre>\n";
print_r($ipp->status);
echo "</pre>";


/* get debugging informations */
echo "<h3>Debug</h3><pre>";
$ipp->printDebug();
echo "</pre>";
?>
