/*
 * pdsfuncs.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsfuncs.h
 *  \author Fernando Pujaico Rivera
 *  \date 03-01-2012
 *  \brief Funciones que trabajan con vectores con elementos de tipo PdsNInput.
 *  
 *  <br>Estas funciones trabajan con una neurona de la forma.<br>
 *  \image html PdsNInput.png "Neurona de entrada de tipo PdsNInput."
 *  \f[ NInput=\{Y[0], Y[1]\} \f].
 */

#ifndef __PDSFUNCS_H__
#define __PDSFUNCS_H__

#ifdef __cplusplus
extern "C" {
#endif 


/** \defgroup PdsFuncsGroup Funciones de activación.
 *  \brief Funciones que pueden ser usadas como función de activación.
 *  
 * @{
 */


/** \fn double pds_func(double x)
 *  \brief Función de activación de la neurona de tipo PdsNeuron.
 *  \f[ func(x)=\frac{2}{1+e^{-x}} -1 \f].
 *  \param[in] x Parámetro a evaluar.
 *  \return El resultado de la función. 
 *  \ingroup PdsFuncsGroup
 */
double pds_func(double x);


/** \fn double pds_dfunc(double x)
 *  \brief Derivada de la función de activación de la neurona de tipo PdsNeuron.
 *  \f[ \frac{\partial  func(x)}{\partial x}=\frac{1-func(x)^2}{2} \f].
 *  \param[in] x Parámetro a evaluar.
 *  \return El resultado de la derivada de la función. 
 *  \ingroup PdsFuncsGroup
 */
double pds_dfunc(double x);


/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif


