/*
 * testprog5.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog5.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-07-2018
 *  \brief Programa para el testeo de las funciones de estatistica.
 *  
 */

#include <stdlib.h>
#include <pds/pdsra.h>

int main(int argc, char** argv)
{
    PdsRaReal mean,std,pcc;


	PdsMatrix *Mat0 =pds_matrix_new(1000,1000);
	PdsMatrix *Mat1 =pds_matrix_new(1000,1000);

    pds_matrix_init_rand(Mat0);
    pds_matrix_init_rand(Mat1);
  	printf("\n");

    ////////////////////////////////////////////////////////////////////////////
	printf("Complete matrix\n");
    pds_matrix_std_and_mean(Mat0,&std,&mean);
    pds_matrix_corr_matrix(Mat0,Mat1,&pcc);

	printf("MEAN:%f\n",mean);
	printf(" STD:%f\n",std);
	printf(" PCC:%f\n",pcc);
	printf("\n");

    ////////////////////////////////////////////////////////////////////////////
	printf("Rectangular region of matrix\n");
    PdsRegionRect A,B;

    A.L0=100;   A.C0=100;   A.Nlin=400;   A.Ncol=400;
    B.L0=300;   B.C0=300;   B.Nlin=400;   B.Ncol=400;

    pds_matrix_std_and_mean_of_region(Mat0,A,&std,&mean);
    pds_matrix_corr_matrix_of_region(Mat0,Mat1,A,B,&pcc);
	printf("MEAN:%f\n",mean);
	printf(" STD:%f\n",std);
	printf(" PCC:%f\n",pcc);
	printf("\n");

	return EXIT_SUCCESS;
}
