/*
 * testprog4.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog4.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-08-2016
 *  \brief Programa para el testeo de las funciones para salvar matrices.
 *  
 *  \n\n Este programa muestra como salvar matrices en BMP 
 */

#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>

int main(int argc, char** argv)
{
	PdsMatrix *Z=NULL;

	PdsRaReal x,y,z;
	int i,j,N,L;
	
	////////////////////////////////////////////////////////////////////////

    N=480;
    L=4;
	Z =pds_matrix_new(N,N);


    for(i=0;i<N;i++)
    for(j=0;j<N;j++)
    {
        x=-L+(L*2.0*i)/(N-1.0);
        y=-L+(L*2.0*j)/(N-1.0);

        z=3.0*pow(1.0-x,2)*exp(-pow(x,2) - pow(1.0+y,2) ) - 10*(x/5.0 - pow(x,3) - pow(y,5))*exp(-pow(x,2)-pow(y,2)) - (1.0/3.0)*exp(-pow(x+1.0,2) - pow(y,2)) ;

        Z->M[i][j]=(z*126.0/8)+127;

    }

    //pds_matrix_octave_surf(Z,"X","Y","Z","testando.m","pds_matrix_octave_surf.png");
    pds_matrix_save_grayscale_bmp(Z,"pds_matrix_save_grayscale_bmp.bmp");
    pds_matrix_save_bmp_with_colormap(Z,"pds_matrix_save_bmp_with_colormap_gray.bmp", PDS_COLORMAP_GRAY);
    pds_matrix_save_bmp_with_colormap(Z,"pds_matrix_save_bmp_with_colormap_jet.bmp", PDS_COLORMAP_JET);
    pds_matrix_save_bmp_with_colormap(Z,"pds_matrix_save_bmp_with_colormap_bone.bmp", PDS_COLORMAP_BONE);
    pds_matrix_save_bmp_with_colormap(Z,"pds_matrix_save_bmp_with_colormap_hot.bmp", PDS_COLORMAP_HOT);
    pds_matrix_save_bmp_with_colormap(Z,"pds_matrix_save_bmp_with_colormap_jolly.bmp", PDS_COLORMAP_JOLLY);
	return EXIT_SUCCESS;
}
