/*
 * pdsrautils.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */
#include <pds/pdsrautils.h>
#include <math.h>




/** \fn int pds_load_number_of_columns_and_lines(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl)
 *  \brief Encuentra el número de columnas y de lineas dentro de un archivo.
 *  si el número de columnas no es constante dentro del archivo, la función 
 *  retorna PDS_WRONG, y carga en nc y nl la posición aproximada del error.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB como delimitarode columna y un salto de linea como delimitador de fila.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] nc Número de columnas en el archivo.
 *  \param[out] nl Número de lineas en el archivo.
 *  \return PDS_OK si todo fue bien o PDS_WRONG si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_load_number_of_columns_and_lines(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl)
{
	PdsRaNatural ncol,ncol_total,last_ncol,nlin;
	char x[__MAX_CHAR_DATA_SIZE__],c;
	//fpos_t *pos=NULL;
	char TAB='\t';
	char SPACE=' ';
	int tmp;

	if(nc==NULL)	return PDS_WRONG;
	if(nl==NULL)	return PDS_WRONG;
	if(fd==NULL)	return PDS_WRONG;
    
    ncol_total=0;
	nlin=0;
	ncol=0;
    last_ncol=0;
	while(feof(fd)==0)
	{
		x[0]=0;

		tmp=fscanf(fd,"%s",x);
		c=(char)fgetc(fd);


        if((strlen(x)==0)||(tmp!=1)) break;

        ncol=ncol+1;
        last_ncol=ncol;
        if(nlin==0) ncol_total=ncol; 

        if( (c!=TAB)&&(c!=SPACE) )
        {
            nlin=nlin+1;

            if(ncol_total!=ncol)
            {
                *nl=nlin-1;
                *nc=ncol-1;
                return PDS_WRONG;
            }
            ncol=0;
        }

        //printf("TMP:%d\tS:[%s]\tC:[%d]\tnl:%d\tnc:%d\tlast_nc:%d\n",tmp,x,c,nlin,ncol,last_ncol);	

	}

	rewind(fd);


	*nl=nlin;
	*nc=ncol_total;

    if(last_ncol!=ncol_total)   return PDS_WRONG;
	if(ncol_total==0)	return PDS_WRONG;
	if(nlin==0)	        return PDS_WRONG;


	return PDS_OK;
}

/** \fn int pds_load_number_of_elements(FILE *fd,PdsRaNatural *n)
 *  \brief Encuentra el número de elementos dentro de un archivo.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB o un salto de linea como delimitador de elemento.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] n Número de elementos en el archivo.
 *  \return PDS_OK si todo fue bien o PDS_WRONG si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_load_number_of_elements(FILE *fd,PdsRaNatural *n)
{
	//PdsRaNatural i;
	int tmp;
	char x[__MAX_CHAR_DATA_SIZE__];

	if(fd==NULL)	return PDS_WRONG;
	if( n==NULL)	return PDS_WRONG;

	*n=0;

	while(feof(fd)==0)
	{
		x[0]=0;
		tmp=fscanf(fd,"%s",x);
		if((strlen(x)==0)||(tmp!=1))	break;
		(*n)++;
	}
	rewind(fd);
	if(*n==0)	return PDS_WRONG;

	return PDS_OK;
}


