/*
 * pdsrautils.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsrautils.h
 *  \author Fernando Pujaico Rivera
 *  \date 18-01-2012
 *  \brief Funciones que necesita la biblioteca.
 *  
 */

#ifndef __PDSRAUTILS_H__
#define __PDSRAUTILS_H__

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pds/pdsraglobal.h>

#ifndef TRUE
	#define TRUE 1
#endif

#ifndef FALSE
	#define FALSE 0
#endif

/** \defgroup PdsRaUtilsGroup Funciones útiles de la biblioteca.
 *  \brief Funciones útiles de la biblioteca.
 *  
 * @{
 */

/** \def __MAX_CHAR_DATA_SIZE__
 *  Indica la cantidad máxima de caracteres que puede tener un dato, en un 
 *  archivo de texto, al momento de ser leido.
 *  \ingroup PdsRaUtilsGroup
 */
#define __MAX_CHAR_DATA_SIZE__	128

/** \fn int pds_ra_ncolumns_nlines_in_file(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl)
 *  \brief Encuentra el número de columnas y de lineas dentro de un archivo.
 *  si el número de columnas no es constante dentro del archivo, la función 
 *  retorna FALSE, y carga en nc y nl la posición aproximada del error.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB como delimitarode columna y un salto de linea como delimitador de fila.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] nc Número de columnas en el archivo.
 *  \param[out] nl Número de lineas en el archivo.
 *  \return TRUE si todo fue bien o FALSE si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_ra_ncolumns_nlines_in_file(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl);



/** \fn int pds_ra_nelements_in_file(FILE *fd,PdsRaNatural *n)
 *  \brief Encuentra el número de elementos dentro de un archivo.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB o un salto de linea como delimitador de elemento.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] n Número de elementos en el archivo.
 *  \return TRUE si todo fue bien o FALSE si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_ra_nelements_in_file(FILE *fd,PdsRaNatural *n);

/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif


